/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative;

import io.prestosql.Session;
import io.prestosql.cost.CostProvider;
import io.prestosql.cost.StatsProvider;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Objects;
import java.util.Optional;

public interface Rule<T> {
    public Pattern<T> getPattern();

    default public boolean isEnabled(Session session) {
        return true;
    }

    public Result apply(T var1, Captures var2, Context var3);

    public static final class Result {
        private final Optional<PlanNode> transformedPlan;

        public static Result empty() {
            return new Result(Optional.empty());
        }

        public static Result ofPlanNode(PlanNode transformedPlan) {
            return new Result(Optional.of(transformedPlan));
        }

        private Result(Optional<PlanNode> transformedPlan) {
            this.transformedPlan = Objects.requireNonNull(transformedPlan, "transformedPlan is null");
        }

        public Optional<PlanNode> getTransformedPlan() {
            return this.transformedPlan;
        }

        public boolean isEmpty() {
            return !this.transformedPlan.isPresent();
        }
    }

    public static interface Context {
        public Lookup getLookup();

        public PlanNodeIdAllocator getIdAllocator();

        public SymbolAllocator getSymbolAllocator();

        public Session getSession();

        public StatsProvider getStatsProvider();

        public CostProvider getCostProvider();

        public void checkTimeoutNotExhausted();

        public WarningCollector getWarningCollector();
    }
}

