/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.Parameter;
import java.util.Map;
import java.util.Objects;

public class ParameterRewriter
extends ExpressionRewriter<Void> {
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private final Analysis analysis;

    public ParameterRewriter(Map<NodeRef<Parameter>, Expression> parameters) {
        Objects.requireNonNull(parameters, "parameterMap is null");
        this.parameters = parameters;
        this.analysis = null;
    }

    public ParameterRewriter(Analysis analysis) {
        this.analysis = analysis;
        this.parameters = analysis.getParameters();
    }

    protected Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        return treeRewriter.defaultRewrite(node, (Object)context);
    }

    public Expression rewriteParameter(Parameter node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        Preconditions.checkState((this.parameters.size() > node.getPosition() ? 1 : 0) != 0, (Object)"Too few parameter values");
        return this.coerceIfNecessary((Expression)node, this.parameters.get(NodeRef.of((Node)node)));
    }

    private Expression coerceIfNecessary(Expression original, Expression rewritten) {
        if (this.analysis == null) {
            return rewritten;
        }
        Type coercion = this.analysis.getCoercion(original);
        if (coercion != null) {
            rewritten = new Cast(rewritten, TypeSignatureTranslator.toSqlType(coercion), false, this.analysis.isTypeOnlyCoercion(original));
        }
        return rewritten;
    }
}

