/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.prestosql.sql.planner.optimizations.OptimizerStats;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.MBeanExport;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

public class OptimizerStatsRecorder {
    private final Map<Class<?>, OptimizerStats> stats = new HashMap();
    @GuardedBy(value="this")
    private final List<MBeanExport> mbeanExports = new ArrayList<MBeanExport>();

    public void register(PlanOptimizer optimizer) {
        Objects.requireNonNull(optimizer, "optimizer is null");
        Preconditions.checkArgument((!optimizer.getClass().isAnonymousClass() ? 1 : 0) != 0);
        this.stats.put(optimizer.getClass(), new OptimizerStats());
    }

    public void record(PlanOptimizer optimizer, long nanos) {
        Objects.requireNonNull(optimizer, "optimizer is null");
        OptimizerStats optimizerStats = Objects.requireNonNull(this.stats.get(optimizer.getClass()), "optimizer is not registered");
        optimizerStats.record(nanos);
    }

    public void recordFailure(PlanOptimizer optimizer) {
        Objects.requireNonNull(optimizer, "optimizer is null");
        OptimizerStats optimizerStats = Objects.requireNonNull(this.stats.get(optimizer.getClass()), "optimizer is not registered");
        optimizerStats.recordFailure();
    }

    synchronized void export(MBeanExporter exporter) {
        Preconditions.checkState((boolean)this.mbeanExports.isEmpty(), (Object)"MBeans already exported");
        for (Map.Entry<Class<?>, OptimizerStats> entry : this.stats.entrySet()) {
            Verify.verify((!entry.getKey().getSimpleName().isEmpty() ? 1 : 0) != 0);
            try {
                this.mbeanExports.add(exporter.exportWithGeneratedName((Object)entry.getValue(), PlanOptimizer.class, (Map)ImmutableMap.builder().put((Object)"name", (Object)PlanOptimizer.class.getSimpleName()).put((Object)"optimizer", (Object)entry.getKey().getSimpleName()).build()));
            }
            catch (RuntimeException e) {
                throw new RuntimeException(String.format("Failed to export MBean with name '%s'", this.getName(entry.getKey())), e);
            }
        }
    }

    synchronized void unexport(MBeanExporter exporter) {
        for (MBeanExport mbeanExport : this.mbeanExports) {
            mbeanExport.unexport();
        }
        this.mbeanExports.clear();
    }

    private String getName(Class<?> key) {
        return ObjectNames.builder(PlanOptimizer.class).withProperty("optimizer", key.getSimpleName()).build();
    }
}

