/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.DeterminismEvaluator;
import io.prestosql.sql.planner.ExpressionNodeInliner;
import io.prestosql.sql.planner.NullabilityAnalyzer;
import io.prestosql.sql.planner.SubExpressionExtractor;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.util.DisjointSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class EqualityInference {
    private static final Ordering<Expression> CANONICAL_ORDERING = Ordering.from((expression1, expression2) -> ComparisonChain.start().compare(SymbolsExtractor.extractAll(expression1).size(), SymbolsExtractor.extractAll(expression2).size()).compare(SubExpressionExtractor.extract(expression1).size(), SubExpressionExtractor.extract(expression2).size()).compare((Comparable)((Object)expression1.toString()), (Comparable)((Object)expression2.toString())).result());
    private final Multimap<Expression, Expression> equalitySets;
    private final Map<Expression, Expression> canonicalMap;
    private final Set<Expression> derivedExpressions;

    private EqualityInference(Multimap<Expression, Expression> equalitySets, Map<Expression, Expression> canonicalMap, Set<Expression> derivedExpressions) {
        this.equalitySets = equalitySets;
        this.canonicalMap = canonicalMap;
        this.derivedExpressions = derivedExpressions;
    }

    public Expression rewrite(Expression expression, Set<Symbol> scope) {
        return this.rewrite(expression, scope::contains, true);
    }

    public EqualityPartition generateEqualitiesPartitionedBy(Set<Symbol> scope) {
        ImmutableSet.Builder scopeEqualities = ImmutableSet.builder();
        ImmutableSet.Builder scopeComplementEqualities = ImmutableSet.builder();
        ImmutableSet.Builder scopeStraddlingEqualities = ImmutableSet.builder();
        for (Collection equalitySet : this.equalitySets.asMap().values()) {
            LinkedHashSet<Expression> scopeExpressions = new LinkedHashSet<Expression>();
            LinkedHashSet<Expression> scopeComplementExpressions = new LinkedHashSet<Expression>();
            LinkedHashSet<Expression> scopeStraddlingExpressions = new LinkedHashSet<Expression>();
            List candidates = equalitySet.stream().filter(candidate -> !this.derivedExpressions.contains(candidate)).collect(Collectors.toList());
            for (Expression candidate2 : candidates) {
                Expression scopeComplementRewritten;
                Expression scopeRewritten = this.rewrite(candidate2, scope::contains, false);
                if (scopeRewritten != null) {
                    scopeExpressions.add(scopeRewritten);
                }
                if ((scopeComplementRewritten = this.rewrite(candidate2, expression -> !scope.contains(expression), false)) != null) {
                    scopeComplementExpressions.add(scopeComplementRewritten);
                }
                if (scopeRewritten != null || scopeComplementRewritten != null) continue;
                scopeStraddlingExpressions.add(candidate2);
            }
            Expression matchingCanonical = EqualityInference.getCanonical(scopeExpressions);
            if (scopeExpressions.size() >= 2) {
                scopeExpressions.stream().filter(expression -> !expression.equals((Object)matchingCanonical)).map(expression -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, matchingCanonical, expression)).forEach(arg_0 -> ((ImmutableSet.Builder)scopeEqualities).add(arg_0));
            }
            Expression complementCanonical = EqualityInference.getCanonical(scopeComplementExpressions);
            if (scopeComplementExpressions.size() >= 2) {
                scopeComplementExpressions.stream().filter(expression -> !expression.equals((Object)complementCanonical)).map(expression -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, complementCanonical, expression)).forEach(arg_0 -> ((ImmutableSet.Builder)scopeComplementEqualities).add(arg_0));
            }
            ArrayList<Expression> connectingExpressions = new ArrayList<Expression>();
            connectingExpressions.add(matchingCanonical);
            connectingExpressions.add(complementCanonical);
            connectingExpressions.addAll(scopeStraddlingExpressions);
            Expression connectingCanonical = EqualityInference.getCanonical(connectingExpressions = connectingExpressions.stream().filter(Objects::nonNull).collect(Collectors.toList()));
            if (connectingCanonical == null) continue;
            connectingExpressions.stream().filter(expression -> !expression.equals((Object)connectingCanonical)).map(expression -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, connectingCanonical, expression)).forEach(arg_0 -> ((ImmutableSet.Builder)scopeStraddlingEqualities).add(arg_0));
        }
        return new EqualityPartition((Iterable<Expression>)scopeEqualities.build(), (Iterable<Expression>)scopeComplementEqualities.build(), (Iterable<Expression>)scopeStraddlingEqualities.build());
    }

    public static boolean isInferenceCandidate(Metadata metadata, Expression expression) {
        ComparisonExpression comparison;
        if (expression instanceof ComparisonExpression && DeterminismEvaluator.isDeterministic(expression, metadata) && !NullabilityAnalyzer.mayReturnNullOnNonNullInput(expression) && (comparison = (ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL) {
            return !comparison.getLeft().equals((Object)comparison.getRight());
        }
        return false;
    }

    public static EqualityInference newInstance(Metadata metadata, Expression ... expressions) {
        return EqualityInference.newInstance(metadata, Arrays.asList(expressions));
    }

    public static EqualityInference newInstance(Metadata metadata, Collection<Expression> expressions) {
        DisjointSet<Expression> equalities = new DisjointSet<Expression>();
        List candidates = expressions.stream().flatMap(expression -> ExpressionUtils.extractConjuncts(expression).stream()).filter(expression -> EqualityInference.isInferenceCandidate(metadata, expression)).collect(Collectors.toList());
        for (Expression expression2 : candidates) {
            ComparisonExpression comparison = (ComparisonExpression)expression2;
            Expression expression3 = comparison.getLeft();
            Expression expression22 = comparison.getRight();
            equalities.findAndUnion(expression3, expression22);
        }
        Collection equivalentClasses = equalities.getEquivalentClasses();
        HashMap byExpression = new HashMap();
        for (Set set : equivalentClasses) {
            set.forEach(expression -> byExpression.put(expression, (ImmutableSet)set));
        }
        LinkedHashSet<Expression> derivedExpressions = new LinkedHashSet<Expression>();
        for (Expression expression3 : byExpression.keySet()) {
            if (derivedExpressions.contains(expression3)) continue;
            List subExpressions = SubExpressionExtractor.extract(expression3).stream().filter(e -> !e.equals((Object)expression3)).collect(Collectors.toList());
            for (Expression subExpression : subExpressions) {
                Set equivalences = ((Set)byExpression.getOrDefault(subExpression, ImmutableSet.of())).stream().filter(e -> !e.equals((Object)subExpression)).collect(Collectors.toSet());
                for (Expression equivalentSubExpression : equivalences) {
                    Expression rewritten = ExpressionNodeInliner.replaceExpression(expression3, (Map<? extends Expression, ? extends Expression>)ImmutableMap.of((Object)subExpression, (Object)equivalentSubExpression));
                    equalities.findAndUnion(expression3, rewritten);
                    derivedExpressions.add(rewritten);
                }
            }
        }
        Multimap<Expression, Expression> multimap = EqualityInference.makeEqualitySets(equalities);
        ImmutableMap.Builder canonicalMappings = ImmutableMap.builder();
        for (Map.Entry entry : multimap.entries()) {
            Expression canonical = (Expression)entry.getKey();
            Expression expression4 = (Expression)entry.getValue();
            canonicalMappings.put((Object)expression4, (Object)canonical);
        }
        return new EqualityInference(multimap, (Map<Expression, Expression>)canonicalMappings.build(), derivedExpressions);
    }

    public static List<Expression> nonInferrableConjuncts(Metadata metadata, Expression expression) {
        return ExpressionUtils.extractConjuncts(expression).stream().filter(e -> !EqualityInference.isInferenceCandidate(metadata, e)).collect(Collectors.toList());
    }

    private Expression rewrite(Expression expression, Predicate<Symbol> symbolScope, boolean allowFullReplacement) {
        Set<Object> subExpressions = SubExpressionExtractor.extract(expression);
        if (!allowFullReplacement) {
            subExpressions = subExpressions.stream().filter(e -> !e.equals((Object)expression)).collect(Collectors.toSet());
        }
        ImmutableMap.Builder expressionRemap = ImmutableMap.builder();
        for (Expression subExpression : subExpressions) {
            Expression canonical = this.getScopedCanonical(subExpression, symbolScope);
            if (canonical == null) continue;
            expressionRemap.put((Object)subExpression, (Object)canonical);
        }
        Expression rewritten = ExpressionNodeInliner.replaceExpression(expression, (Map<? extends Expression, ? extends Expression>)expressionRemap.build());
        if (!EqualityInference.isScoped(rewritten, symbolScope)) {
            return null;
        }
        return rewritten;
    }

    private static Expression getCanonical(Collection<Expression> expressions) {
        if (expressions.isEmpty()) {
            return null;
        }
        return (Expression)CANONICAL_ORDERING.min(expressions);
    }

    @VisibleForTesting
    Expression getScopedCanonical(Expression expression, Predicate<Symbol> symbolScope) {
        Expression canonicalIndex = this.canonicalMap.get(expression);
        if (canonicalIndex == null) {
            return null;
        }
        Collection equivalences = this.equalitySets.get((Object)canonicalIndex);
        if (expression instanceof SymbolReference) {
            boolean inScope = equivalences.stream().filter(SymbolReference.class::isInstance).map(Symbol::from).anyMatch(symbolScope);
            if (!inScope) {
                return null;
            }
        }
        Set<Expression> candidates = equivalences.stream().filter(e -> EqualityInference.isScoped(e, symbolScope)).collect(Collectors.toSet());
        return EqualityInference.getCanonical(candidates);
    }

    private static boolean isScoped(Expression expression, Predicate<Symbol> symbolScope) {
        return SymbolsExtractor.extractUnique(expression).stream().allMatch(symbolScope);
    }

    private static Multimap<Expression, Expression> makeEqualitySets(DisjointSet<Expression> equalities) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Set<Expression> equalityGroup : equalities.getEquivalentClasses()) {
            if (equalityGroup.isEmpty()) continue;
            builder.putAll(CANONICAL_ORDERING.min(equalityGroup), equalityGroup);
        }
        return builder.build();
    }

    public static class EqualityPartition {
        private final List<Expression> scopeEqualities;
        private final List<Expression> scopeComplementEqualities;
        private final List<Expression> scopeStraddlingEqualities;

        public EqualityPartition(Iterable<Expression> scopeEqualities, Iterable<Expression> scopeComplementEqualities, Iterable<Expression> scopeStraddlingEqualities) {
            this.scopeEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeEqualities, "scopeEqualities is null"));
            this.scopeComplementEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeComplementEqualities, "scopeComplementEqualities is null"));
            this.scopeStraddlingEqualities = ImmutableList.copyOf(Objects.requireNonNull(scopeStraddlingEqualities, "scopeStraddlingEqualities is null"));
        }

        public List<Expression> getScopeEqualities() {
            return this.scopeEqualities;
        }

        public List<Expression> getScopeComplementEqualities() {
            return this.scopeComplementEqualities;
        }

        public List<Expression> getScopeStraddlingEqualities() {
            return this.scopeStraddlingEqualities;
        }
    }
}

