/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.SubscriptExpression;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DesugarRowSubscriptRewriter {
    private DesugarRowSubscriptRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, TypeAnalyzer typeAnalyzer, SymbolAllocator symbolAllocator) {
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        return DesugarRowSubscriptRewriter.rewrite(expression, expressionTypes);
    }

    public static Expression rewrite(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(expressionTypes), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Map<NodeRef<Expression>, Type> expressionTypes) {
            this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        }

        public Expression rewriteSubscriptExpression(SubscriptExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression base = node.getBase();
            Expression index = node.getIndex();
            SubscriptExpression result = node;
            Type type = this.getType(base);
            if (type instanceof RowType) {
                RowType rowType = (RowType)type;
                int position = Math.toIntExact(((LongLiteral)index).getValue() - 1L);
                Optional fieldName = ((RowType.Field)rowType.getFields().get(position)).getName();
                if (fieldName.isPresent()) {
                    result = new DereferenceExpression(base, new Identifier((String)fieldName.get(), true));
                } else {
                    ImmutableList.Builder namedFields = new ImmutableList.Builder();
                    for (int i = 0; i < rowType.getFields().size(); ++i) {
                        namedFields.add((Object)new RowType.Field(Optional.of("f" + i), (Type)rowType.getTypeParameters().get(i)));
                    }
                    RowType namedRowType = RowType.from((List)namedFields.build());
                    Cast cast = new Cast(base, TypeSignatureTranslator.toSqlType((Type)namedRowType));
                    result = new DereferenceExpression((Expression)cast, new Identifier("f" + position));
                }
            }
            return treeRewriter.defaultRewrite((Expression)result, (Object)context);
        }

        private Type getType(Expression expression) {
            return this.expressionTypes.get(NodeRef.of((Node)expression));
        }
    }
}

