/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.LikePredicate;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.type.LikePatternType;
import java.util.Map;
import java.util.Objects;

public final class DesugarLikeRewriter {
    public static Expression rewrite(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes, Metadata metadata) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(expressionTypes, metadata), (Expression)expression);
    }

    private DesugarLikeRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider typeProvider) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, typeProvider, expression);
        return DesugarLikeRewriter.rewrite(expression, expressionTypes, metadata);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Map<NodeRef<Expression>, Type> expressionTypes;
        private final Metadata metadata;

        public Visitor(Map<NodeRef<Expression>, Type> expressionTypes, Metadata metadata) {
            this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
            this.metadata = metadata;
        }

        public FunctionCall rewriteLikePredicate(LikePredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            LikePredicate rewritten = (LikePredicate)treeRewriter.defaultRewrite((Expression)node, (Object)context);
            FunctionCall patternCall = rewritten.getEscape().isPresent() ? new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"$like_pattern")).addArgument(this.getType(node.getPattern()), rewritten.getPattern()).addArgument(this.getType((Expression)node.getEscape().get()), (Expression)rewritten.getEscape().get()).build() : new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"$like_pattern")).addArgument((Type)VarcharType.VARCHAR, rewritten.getPattern()).build();
            return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"LIKE")).addArgument(this.getType(node.getValue()), rewritten.getValue()).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)patternCall).build();
        }

        private Type getType(Expression expression) {
            return this.expressionTypes.get(NodeRef.of((Node)expression));
        }
    }
}

