/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.SqlTypeBytecodeExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.RowExpression;
import java.util.List;

public class DereferenceCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(ResolvedFunction resolvedFunction, BytecodeGeneratorContext generator, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CallSiteBinder callSiteBinder = generator.getCallSiteBinder();
        BytecodeBlock block = new BytecodeBlock().comment("DEREFERENCE").setDescription("DEREFERENCE");
        Variable wasNull = generator.wasNull();
        Variable rowBlock = generator.getScope().createTempVariable(Block.class);
        int index = (Integer)((ConstantExpression)arguments.get(1)).getValue();
        block.putVariable(wasNull, false);
        block.append(generator.generate(arguments.get(0))).putVariable(rowBlock);
        IfStatement ifRowBlockIsNull = new IfStatement("if row block is null...", new Object[0]).condition((BytecodeNode)wasNull);
        Class javaType = returnType.getJavaType();
        LabelNode end = new LabelNode("end");
        ifRowBlockIsNull.ifTrue().comment("if row block is null, push null to the stack and goto 'end' label (return)").putVariable(wasNull, true).pushJavaDefault(javaType).gotoLabel(end);
        block.append((BytecodeNode)ifRowBlockIsNull);
        IfStatement ifFieldIsNull = new IfStatement("if row field is null...", new Object[0]);
        ifFieldIsNull.condition().comment("call rowBlock.isNull(index)").append((BytecodeNode)rowBlock).push(index).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE});
        ifFieldIsNull.ifTrue().comment("if the field is null, push null to stack").putVariable(wasNull, true).pushJavaDefault(javaType);
        BytecodeExpression value = SqlTypeBytecodeExpression.constantType(callSiteBinder, returnType).getValue((BytecodeExpression)rowBlock, BytecodeExpressions.constantInt((int)index));
        ifFieldIsNull.ifFalse().comment("otherwise call type.getTYPE(rowBlock, index)").append((BytecodeNode)value).putVariable(wasNull, false);
        block.append((BytecodeNode)ifFieldIsNull).visitLabel(end);
        return block;
    }
}

