/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.instruction.LabelNode;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.BytecodeGenerator;
import io.prestosql.sql.gen.BytecodeGeneratorContext;
import io.prestosql.sql.gen.BytecodeUtils;
import io.prestosql.sql.gen.RowExpressionCompiler;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SpecialForm;
import io.prestosql.sql.relational.StandardFunctionResolution;
import io.prestosql.sql.relational.VariableReferenceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import java.util.List;

public class BetweenCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(ResolvedFunction resolvedFunction, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        RowExpression value = arguments.get(0);
        RowExpression min = arguments.get(1);
        RowExpression max = arguments.get(2);
        Variable firstValue = context.getScope().createTempVariable(value.getType().getJavaType());
        VariableReferenceExpression valueReference = RowExpressionCompiler.createTempVariableReferenceExpression(firstValue, value.getType());
        StandardFunctionResolution standardFunctionResolution = new StandardFunctionResolution(context.getMetadata());
        SpecialForm newExpression = new SpecialForm(SpecialForm.Form.AND, (Type)BooleanType.BOOLEAN, Expressions.call(standardFunctionResolution.comparisonFunction(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, value.getType(), min.getType()), (Type)BooleanType.BOOLEAN, valueReference, min), Expressions.call(standardFunctionResolution.comparisonFunction(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, value.getType(), max.getType()), (Type)BooleanType.BOOLEAN, valueReference, max));
        LabelNode done = new LabelNode("done");
        BytecodeBlock block = new BytecodeBlock().comment("check if value is null").append(context.generate(value)).append(BytecodeUtils.ifWasNullPopAndGoto(context.getScope(), done, Boolean.TYPE, value.getType().getJavaType())).putVariable(firstValue).append(context.generate(newExpression)).visitLabel(done);
        return block;
    }
}

