/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.SqlFormatter;
import io.prestosql.sql.parser.ParsingException;
import io.prestosql.sql.parser.ParsingOptions;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Statement;
import javax.annotation.Nullable;

public final class SqlFormatterUtil {
    private SqlFormatterUtil() {
    }

    public static String getFormattedSql(Statement statement, SqlParser sqlParser) {
        Statement parsed;
        String sql = SqlFormatter.formatSql((Node)statement);
        try {
            ParsingOptions parsingOptions = new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.REJECT);
            parsed = sqlParser.createStatement(sql, parsingOptions);
        }
        catch (ParsingException e) {
            throw SqlFormatterUtil.formattingFailure(e, "Formatted query does not parse", statement, sql);
        }
        if (!statement.equals((Object)parsed)) {
            throw SqlFormatterUtil.formattingFailure(null, "Query does not round-trip", statement, sql);
        }
        return sql;
    }

    private static PrestoException formattingFailure(@Nullable Throwable cause, String message, Statement statement, String sql) {
        PrestoException exception = new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, message, cause);
        exception.addSuppressed((Throwable)new RuntimeException("Statement: " + statement));
        exception.addSuppressed((Throwable)new RuntimeException(String.format("Formatted: [%s]", sql)));
        return exception;
    }
}

