/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spiller;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FileHolder
implements Closeable {
    private final Path filePath;
    @GuardedBy(value="this")
    private boolean deleted;

    public FileHolder(Path filePath) {
        this.filePath = Objects.requireNonNull(filePath, "filePath is null");
    }

    public synchronized OutputStream newOutputStream(OpenOption ... options) throws IOException {
        Preconditions.checkState((!this.deleted ? 1 : 0) != 0, (Object)"File already deleted");
        return Files.newOutputStream(this.filePath, options);
    }

    public synchronized InputStream newInputStream(OpenOption ... options) throws IOException {
        Preconditions.checkState((!this.deleted ? 1 : 0) != 0, (Object)"File already deleted");
        return Files.newInputStream(this.filePath, options);
    }

    @Override
    public synchronized void close() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        try {
            Files.delete(this.filePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

