/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import com.google.common.io.ByteStreams;
import io.prestosql.server.ui.FormWebUiAuthenticationManager;
import io.prestosql.server.ui.WebUiAuthenticationManager;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DisabledWebUiAuthenticationManager
implements WebUiAuthenticationManager {
    private static final String DISABLED_LOCATION = "/ui/disabled.html";

    @Override
    public void handleUiRequest(HttpServletRequest request, HttpServletResponse response, FilterChain nextFilter) throws IOException, ServletException {
        if (request.getPathInfo() == null || request.getPathInfo().equals("/")) {
            response.setHeader("Location", DisabledWebUiAuthenticationManager.getRedirectLocation(request, DISABLED_LOCATION));
            response.setStatus(303);
            return;
        }
        if (DisabledWebUiAuthenticationManager.isPublic(request)) {
            nextFilter.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try (ServletInputStream inputStream = request.getInputStream();){
            ByteStreams.exhaust((InputStream)inputStream);
        }
        if (request.getPathInfo().startsWith("/ui/api/")) {
            response.setStatus(401);
        } else {
            response.setHeader("Location", DisabledWebUiAuthenticationManager.getRedirectLocation(request, DISABLED_LOCATION));
            response.setStatus(303);
        }
    }

    private static boolean isPublic(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        return pathInfo.equals(DISABLED_LOCATION) || pathInfo.startsWith("/ui/vendor") || pathInfo.startsWith("/ui/assets");
    }

    private static String getRedirectLocation(HttpServletRequest request, String path) {
        return FormWebUiAuthenticationManager.getRedirectLocation(request, path, null);
    }
}

