/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.jaxrs.JaxrsBinder;
import io.prestosql.server.ui.ClusterResource;
import io.prestosql.server.ui.ClusterStatsResource;
import io.prestosql.server.ui.DisabledWebUiAuthenticationManager;
import io.prestosql.server.ui.FormWebUiAuthenticationManager;
import io.prestosql.server.ui.UiQueryResource;
import io.prestosql.server.ui.WebUiAuthenticationManager;
import io.prestosql.server.ui.WebUiConfig;

public class WebUiModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        HttpServerBinder.httpServerBinder((Binder)binder).bindResource("/ui", "webapp").withWelcomeFile("index.html");
        ConfigBinder.configBinder((Binder)binder).bindConfig(WebUiConfig.class);
        if (((WebUiConfig)this.buildConfigObject(WebUiConfig.class)).isEnabled()) {
            binder.bind(WebUiAuthenticationManager.class).to(FormWebUiAuthenticationManager.class).in(Scopes.SINGLETON);
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(ClusterResource.class);
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(ClusterStatsResource.class);
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(UiQueryResource.class);
        } else {
            binder.bind(WebUiAuthenticationManager.class).to(DisabledWebUiAuthenticationManager.class).in(Scopes.SINGLETON);
        }
    }
}

