/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.hash.Hashing;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.prestosql.server.InternalCommunicationConfig;
import io.prestosql.server.security.InternalPrincipal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

public class InternalAuthenticationManager
implements HttpRequestFilter {
    private static final Logger log = Logger.get(InternalAuthenticationManager.class);
    private static final String PRESTO_INTERNAL_BEARER = "X-Presto-Internal-Bearer";
    private final byte[] hmac;
    private final String nodeId;

    @Inject
    public InternalAuthenticationManager(InternalCommunicationConfig internalCommunicationConfig, NodeInfo nodeInfo) {
        this(InternalAuthenticationManager.getSharedSecret(internalCommunicationConfig, nodeInfo), nodeInfo.getNodeId());
    }

    private static String getSharedSecret(InternalCommunicationConfig internalCommunicationConfig, NodeInfo nodeInfo) {
        Objects.requireNonNull(internalCommunicationConfig, "internalCommunicationConfig is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        if (!internalCommunicationConfig.isRequiredSharedSecretSet()) {
            throw new IllegalArgumentException("Shared secret is required when internal communications uses https");
        }
        return internalCommunicationConfig.getSharedSecret().orElseGet(() -> ((NodeInfo)nodeInfo).getEnvironment());
    }

    public InternalAuthenticationManager(String sharedSecret, String nodeId) {
        Objects.requireNonNull(sharedSecret, "sharedSecret is null");
        Objects.requireNonNull(nodeId, "nodeId is null");
        this.hmac = Hashing.sha256().hashString((CharSequence)sharedSecret, StandardCharsets.UTF_8).asBytes();
        this.nodeId = nodeId;
    }

    public boolean isInternalRequest(HttpServletRequest request) {
        return request.getHeader(PRESTO_INTERNAL_BEARER) != null;
    }

    public Principal authenticateInternalRequest(HttpServletRequest request) {
        String internalBarer = request.getHeader(PRESTO_INTERNAL_BEARER);
        try {
            String subject = this.parseJwt(internalBarer);
            return new InternalPrincipal(subject);
        }
        catch (JwtException e) {
            log.error((Throwable)e, "Internal authentication failed");
            return null;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
    }

    public Request filterRequest(Request request) {
        return Request.Builder.fromRequest((Request)request).addHeader(PRESTO_INTERNAL_BEARER, this.generateJwt()).build();
    }

    private String generateJwt() {
        return Jwts.builder().signWith(SignatureAlgorithm.HS256, this.hmac).setSubject(this.nodeId).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
    }

    private String parseJwt(String jwt) {
        return ((Claims)Jwts.parser().setSigningKey(this.hmac).parseClaimsJws(jwt).getBody()).getSubject();
    }
}

