/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.RankingWindowFunction;
import io.prestosql.spi.function.WindowFunctionSignature;
import io.prestosql.spi.type.DoubleType;

@WindowFunctionSignature(name="percent_rank", returnType="double")
public class PercentRankFunction
extends RankingWindowFunction {
    private long totalCount;
    private long rank;
    private long count;

    public void reset() {
        this.totalCount = this.windowIndex.size();
        this.rank = 0L;
        this.count = 1L;
    }

    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount, int currentPosition) {
        if (this.totalCount == 1L) {
            DoubleType.DOUBLE.writeDouble(output, 0.0);
            return;
        }
        if (newPeerGroup) {
            this.rank += this.count;
            this.count = 1L;
        } else {
            ++this.count;
        }
        DoubleType.DOUBLE.writeDouble(output, (double)(this.rank - 1L) / (double)(this.totalCount - 1L));
    }
}

