/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.prestosql.client.FailureInfo;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;

public final class FailureFunction {
    private static final JsonCodec<FailureInfo> JSON_CODEC = JsonCodec.jsonCodec(FailureInfo.class);

    private FailureFunction() {
    }

    @Description(value="Decodes json to an exception and throws it")
    @ScalarFunction(value="fail", hidden=true)
    @SqlType(value="unknown")
    public static boolean failWithException(@SqlType(value="json") Slice failureInfoSlice) {
        FailureInfo failureInfo = (FailureInfo)JSON_CODEC.fromJson(failureInfoSlice.getBytes());
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)failureInfo.toException());
    }

    @Description(value="Throws an exception with a given message")
    @ScalarFunction(value="fail", hidden=true)
    @SqlType(value="unknown")
    public static boolean fail(@SqlType(value="varchar") Slice message) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, message.toStringUtf8());
    }

    @Description(value="Throws an exception with a given error code and message")
    @ScalarFunction(value="fail", hidden=true)
    @SqlType(value="unknown")
    public static boolean fail(@SqlType(value="integer") long errorCode, @SqlType(value="varchar") Slice message) {
        for (StandardErrorCode standardErrorCode : StandardErrorCode.values()) {
            if ((long)standardErrorCode.toErrorCode().getCode() != errorCode) continue;
            throw new PrestoException((ErrorCodeSupplier)standardErrorCode, message.toStringUtf8());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unable to find error for code: " + errorCode);
    }
}

