/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ArrayFlattenFunction
extends SqlScalarFunction {
    public static final ArrayFlattenFunction ARRAY_FLATTEN_FUNCTION = new ArrayFlattenFunction();
    private static final String FUNCTION_NAME = "flatten";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayFlattenFunction.class, "flatten", Type.class, Type.class, Block.class);

    private ArrayFlattenFunction() {
        super(new FunctionMetadata(new Signature(FUNCTION_NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("E")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])))), false), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, "Flattens the given array", FunctionKind.SCALAR));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        Type elementType = boundVariables.getTypeVariable("E");
        Type arrayType = metadata.getParameterizedType("array", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)elementType.getTypeSignature())));
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(elementType).bindTo(arrayType);
        return new ScalarFunctionImplementation(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
    }

    public static Block flatten(Type type, Type arrayType, Block array) {
        if (array.getPositionCount() == 0) {
            return type.createBlockBuilder(null, 0).build();
        }
        BlockBuilder builder = type.createBlockBuilder(null, array.getPositionCount(), Math.toIntExact(array.getSizeInBytes() / (long)array.getPositionCount()));
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) continue;
            Block subArray = (Block)arrayType.getObject(array, i);
            for (int j = 0; j < subArray.getPositionCount(); ++j) {
                type.appendTo(subArray, j, builder);
            }
        }
        return builder.build();
    }
}

