/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.operator.aggregation.TypedSet;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;

@ScalarFunction(value="array_except")
@Description(value="Returns an array of elements that are in the first array but not the second, without duplicates.")
public final class ArrayExceptFunction {
    private ArrayExceptFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block except(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        int i;
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (leftPositionCount == 0) {
            return leftArray;
        }
        TypedSet typedSet = new TypedSet(type, leftPositionCount + rightPositionCount, "array_except");
        BlockBuilder distinctElementBlockBuilder = type.createBlockBuilder(null, leftPositionCount);
        for (i = 0; i < rightPositionCount; ++i) {
            typedSet.add(rightArray, i);
        }
        for (i = 0; i < leftPositionCount; ++i) {
            if (typedSet.contains(leftArray, i)) continue;
            typedSet.add(leftArray, i);
            type.appendTo(leftArray, i, distinctElementBlockBuilder);
        }
        return distinctElementBlockBuilder.build();
    }
}

