/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.operator.aggregation.state.LongDecimalWithOverflowState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;

public class LongDecimalWithOverflowStateSerializer
implements AccumulatorStateSerializer<LongDecimalWithOverflowState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(LongDecimalWithOverflowState state, BlockBuilder out) {
        if (state.getLongDecimal() == null) {
            out.appendNull();
        } else {
            Slice slice = Slices.allocate((int)24);
            SliceOutput output = slice.getOutput();
            output.writeLong(state.getOverflow());
            output.writeBytes(state.getLongDecimal());
            VarbinaryType.VARBINARY.writeSlice(out, slice);
        }
    }

    public void deserialize(Block block, int index, LongDecimalWithOverflowState state) {
        if (!block.isNull(index)) {
            BasicSliceInput slice = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
            state.setOverflow(slice.readLong());
            state.setLongDecimal(Slices.copyOf((Slice)slice.readSlice(slice.available())));
        }
    }
}

