/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.stats.QuantileDigest;
import io.prestosql.operator.aggregation.state.DigestAndPercentileState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;

public class DigestAndPercentileStateSerializer
implements AccumulatorStateSerializer<DigestAndPercentileState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(DigestAndPercentileState state, BlockBuilder out) {
        if (state.getDigest() == null) {
            out.appendNull();
        } else {
            Slice serialized = state.getDigest().serialize();
            SliceOutput output = Slices.allocate((int)(12 + serialized.length())).getOutput();
            output.appendDouble(state.getPercentile());
            output.appendInt(serialized.length());
            output.appendBytes(serialized);
            VarbinaryType.VARBINARY.writeSlice(out, output.slice());
        }
    }

    public void deserialize(Block block, int index, DigestAndPercentileState state) {
        BasicSliceInput input = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
        state.setPercentile(input.readDouble());
        int length = input.readInt();
        QuantileDigest digest = new QuantileDigest(input.readSlice(length));
        state.setDigest(digest);
        state.addMemoryUsage(state.getDigest().estimatedInMemorySizeInBytes());
    }
}

