/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.state.LongAndDoubleState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.type.IntervalDayTimeType;

@AggregationFunction(value="avg")
public final class IntervalDayToSecondAverageAggregation {
    private IntervalDayToSecondAverageAggregation() {
    }

    @InputFunction
    public static void input(LongAndDoubleState state, @SqlType(value="interval day to second") long value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + (double)value);
    }

    @CombineFunction
    public static void combine(LongAndDoubleState state, LongAndDoubleState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="interval day to second")
    public static void output(LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            double value = state.getDouble();
            IntervalDayTimeType.INTERVAL_DAY_TIME.writeLong(out, Math.round(value / (double)count));
        }
    }
}

