/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.stats.QuantileDigest;
import io.prestosql.operator.aggregation.state.DigestAndPercentileArrayState;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.util.Failures;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateLongPercentileArrayAggregations {
    private ApproximateLongPercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.initializePercentilesArray(state, percentilesArrayBlock);
        ApproximateLongPercentileArrayAggregations.initializeDigest(state);
        QuantileDigest digest = state.getDigest();
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="double") double weight, @SqlType(value="array(double)") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.initializePercentilesArray(state, percentilesArrayBlock);
        ApproximateLongPercentileArrayAggregations.initializeDigest(state);
        QuantileDigest digest = state.getDigest();
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value, weight);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
    }

    @CombineFunction
    public static void combine(@AggregationState DigestAndPercentileArrayState state, DigestAndPercentileArrayState otherState) {
        QuantileDigest otherDigest = otherState.getDigest();
        QuantileDigest digest = state.getDigest();
        if (digest == null) {
            state.setDigest(otherDigest);
            state.addMemoryUsage(otherDigest.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
            digest.merge(otherDigest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        state.setPercentiles(otherState.getPercentiles());
    }

    @OutputFunction(value="array(bigint)")
    public static void output(@AggregationState DigestAndPercentileArrayState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        for (int i = 0; i < percentiles.size(); ++i) {
            Double percentile = percentiles.get(i);
            BigintType.BIGINT.writeLong(blockBuilder, digest.getQuantile(percentile.doubleValue()));
        }
        out.closeEntry();
    }

    private static void initializePercentilesArray(@AggregationState DigestAndPercentileArrayState state, Block percentilesArrayBlock) {
        if (state.getPercentiles() == null) {
            ImmutableList.Builder percentilesListBuilder = ImmutableList.builder();
            for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
                Failures.checkCondition(!percentilesArrayBlock.isNull(i), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile cannot be null", new Object[0]);
                double percentile = DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i);
                Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
                percentilesListBuilder.add((Object)percentile);
            }
            state.setPercentiles((List<Double>)percentilesListBuilder.build());
        }
    }

    private static void initializeDigest(@AggregationState DigestAndPercentileArrayState state) {
        QuantileDigest digest = state.getDigest();
        if (digest == null) {
            digest = new QuantileDigest(0.01);
            state.setDigest(digest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
    }
}

