/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.Metadata;
import io.prestosql.operator.PagesHashStrategy;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.type.TypeUtils;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.openjdk.jol.info.ClassLayout;

public class SimplePagesHashStrategy
implements PagesHashStrategy {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SimplePagesHashStrategy.class).instanceSize();
    private final List<Type> types;
    private final List<Integer> outputChannels;
    private final List<List<Block>> channels;
    private final List<Integer> hashChannels;
    private final List<Block> precomputedHashChannel;
    private final Optional<Integer> sortChannel;
    private final List<MethodHandle> distinctFromMethodHandles;

    public SimplePagesHashStrategy(List<Type> types, List<Integer> outputChannels, List<List<Block>> channels, List<Integer> hashChannels, OptionalInt precomputedHashChannel, Optional<Integer> sortChannel, Metadata metadata) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
        this.channels = ImmutableList.copyOf((Collection)Objects.requireNonNull(channels, "channels is null"));
        Preconditions.checkArgument((types.size() == channels.size() ? 1 : 0) != 0, (Object)"Expected types and channels to be the same length");
        this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
        this.precomputedHashChannel = precomputedHashChannel.isPresent() ? channels.get(precomputedHashChannel.getAsInt()) : null;
        this.sortChannel = Objects.requireNonNull(sortChannel, "sortChannel is null");
        Objects.requireNonNull(metadata, "metadata is null");
        ImmutableList.Builder distinctFromMethodHandlesBuilder = ImmutableList.builder();
        for (int i = 0; i < hashChannels.size(); ++i) {
            distinctFromMethodHandlesBuilder.add((Object)metadata.getScalarFunctionImplementation(metadata.resolveOperator(OperatorType.IS_DISTINCT_FROM, (List<? extends Type>)ImmutableList.of((Object)types.get(i), (Object)types.get(i)))).getMethodHandle());
        }
        this.distinctFromMethodHandles = distinctFromMethodHandlesBuilder.build();
    }

    @Override
    public int getChannelCount() {
        return this.outputChannels.size();
    }

    @Override
    public long getSizeInBytes() {
        return (long)INSTANCE_SIZE + this.channels.stream().flatMap(Collection::stream).mapToLong(Block::getRetainedSizeInBytes).sum();
    }

    @Override
    public void appendTo(int blockIndex, int position, PageBuilder pageBuilder, int outputChannelOffset) {
        for (int outputIndex : this.outputChannels) {
            Type type = this.types.get(outputIndex);
            List<Block> channel = this.channels.get(outputIndex);
            Block block = channel.get(blockIndex);
            type.appendTo(block, position, pageBuilder.getBlockBuilder(outputChannelOffset));
            ++outputChannelOffset;
        }
    }

    @Override
    public long hashPosition(int blockIndex, int position) {
        if (this.precomputedHashChannel != null) {
            return BigintType.BIGINT.getLong(this.precomputedHashChannel.get(blockIndex), position);
        }
        long result = 0L;
        for (int hashChannel : this.hashChannels) {
            Type type = this.types.get(hashChannel);
            Block block = this.channels.get(hashChannel).get(blockIndex);
            result = result * 31L + TypeUtils.hashPosition(type, block, position);
        }
        return result;
    }

    @Override
    public long hashRow(int position, Page page) {
        long result = 0L;
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            Block block = page.getBlock(i);
            result = result * 31L + TypeUtils.hashPosition(type, block, position);
        }
        return result;
    }

    @Override
    public boolean rowEqualsRow(int leftPosition, Page leftPage, int rightPosition, Page rightPage) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block rightBlock;
            Block leftBlock;
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            if (TypeUtils.positionEqualsPosition(type, leftBlock = leftPage.getBlock(i), leftPosition, rightBlock = rightPage.getBlock(i), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsRow(int leftBlockIndex, int leftPosition, int rightPosition, Page rightPage) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block rightBlock;
            Block leftBlock;
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            if (TypeUtils.positionEqualsPosition(type, leftBlock = this.channels.get(hashChannel).get(leftBlockIndex), leftPosition, rightBlock = rightPage.getBlock(i), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsRowIgnoreNulls(int leftBlockIndex, int leftPosition, int rightPosition, Page rightPage) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block rightBlock;
            Block leftBlock;
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            if (type.equalTo(leftBlock = this.channels.get(hashChannel).get(leftBlockIndex), leftPosition, rightBlock = rightPage.getBlock(i), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsRow(int leftBlockIndex, int leftPosition, int rightPosition, Page page, int[] rightHashChannels) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block rightBlock;
            Block leftBlock;
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            if (TypeUtils.positionEqualsPosition(type, leftBlock = this.channels.get(hashChannel).get(leftBlockIndex), leftPosition, rightBlock = page.getBlock(rightHashChannels[i]), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionNotDistinctFromRow(int leftBlockIndex, int leftPosition, int rightPosition, Page page, int[] rightChannels) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            int hashChannel = this.hashChannels.get(i);
            Block leftBlock = this.channels.get(hashChannel).get(leftBlockIndex);
            Block rightBlock = page.getBlock(rightChannels[i]);
            MethodHandle methodHandle = this.distinctFromMethodHandles.get(i);
            try {
                if (methodHandle.invokeExact(leftBlock, leftPosition, rightBlock, rightPosition)) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return true;
    }

    @Override
    public boolean positionEqualsPosition(int leftBlockIndex, int leftPosition, int rightBlockIndex, int rightPosition) {
        for (int hashChannel : this.hashChannels) {
            Block rightBlock;
            List<Block> channel;
            Block leftBlock;
            Type type = this.types.get(hashChannel);
            if (TypeUtils.positionEqualsPosition(type, leftBlock = (channel = this.channels.get(hashChannel)).get(leftBlockIndex), leftPosition, rightBlock = channel.get(rightBlockIndex), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsPositionIgnoreNulls(int leftBlockIndex, int leftPosition, int rightBlockIndex, int rightPosition) {
        for (int hashChannel : this.hashChannels) {
            Block rightBlock;
            List<Block> channel;
            Block leftBlock;
            Type type = this.types.get(hashChannel);
            if (type.equalTo(leftBlock = (channel = this.channels.get(hashChannel)).get(leftBlockIndex), leftPosition, rightBlock = channel.get(rightBlockIndex), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPositionNull(int blockIndex, int blockPosition) {
        for (int hashChannel : this.hashChannels) {
            if (!this.isChannelPositionNull(hashChannel, blockIndex, blockPosition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareSortChannelPositions(int leftBlockIndex, int leftBlockPosition, int rightBlockIndex, int rightBlockPosition) {
        int channel = this.getSortChannel();
        Block leftBlock = this.channels.get(channel).get(leftBlockIndex);
        Block rightBlock = this.channels.get(channel).get(rightBlockIndex);
        return this.types.get(channel).compareTo(leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
    }

    @Override
    public boolean isSortChannelPositionNull(int blockIndex, int blockPosition) {
        return this.isChannelPositionNull(this.getSortChannel(), blockIndex, blockPosition);
    }

    private boolean isChannelPositionNull(int channelIndex, int blockIndex, int blockPosition) {
        List<Block> channel = this.channels.get(channelIndex);
        Block block = channel.get(blockIndex);
        return block.isNull(blockPosition);
    }

    private int getSortChannel() {
        return this.sortChannel.get();
    }
}

