/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.annotations.VisibleForTesting;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.operator.BigintGroupByHash;
import io.prestosql.operator.GroupByIdBlock;
import io.prestosql.operator.MultiChannelGroupByHash;
import io.prestosql.operator.UpdateMemory;
import io.prestosql.operator.Work;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.JoinCompiler;
import java.util.List;
import java.util.Optional;

public interface GroupByHash {
    public static GroupByHash createGroupByHash(Session session, List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize, JoinCompiler joinCompiler) {
        return GroupByHash.createGroupByHash(hashTypes, hashChannels, inputHashChannel, expectedSize, SystemSessionProperties.isDictionaryAggregationEnabled(session), joinCompiler, UpdateMemory.NOOP);
    }

    public static GroupByHash createGroupByHash(List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize, boolean processDictionary, JoinCompiler joinCompiler, UpdateMemory updateMemory) {
        if (hashTypes.size() == 1 && hashTypes.get(0).equals(BigintType.BIGINT) && hashChannels.length == 1) {
            return new BigintGroupByHash(hashChannels[0], inputHashChannel.isPresent(), expectedSize, updateMemory);
        }
        return new MultiChannelGroupByHash(hashTypes, hashChannels, inputHashChannel, expectedSize, processDictionary, joinCompiler, updateMemory);
    }

    public long getEstimatedSize();

    public long getHashCollisions();

    public double getExpectedHashCollisions();

    public List<Type> getTypes();

    public int getGroupCount();

    public void appendValuesTo(int var1, PageBuilder var2, int var3);

    public Work<?> addPage(Page var1);

    public Work<GroupByIdBlock> getGroupIds(Page var1);

    public boolean contains(int var1, Page var2, int[] var3);

    default public boolean contains(int position, Page page, int[] hashChannels, long rawHash) {
        return this.contains(position, page, hashChannels);
    }

    public long getRawHash(int var1);

    @VisibleForTesting
    public int getCapacity();
}

