/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.prestosql.execution.TaskId;
import io.prestosql.operator.BasicWorkProcessorOperatorAdapter;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.ProcessorContext;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class AssignUniqueIdOperator
implements WorkProcessorOperator {
    private static final long ROW_IDS_PER_REQUEST = 0x100000L;
    private static final long MAX_ROW_ID = 0x10000000000L;
    private final WorkProcessor<Page> pages;

    public static OperatorFactory createOperatorFactory(int operatorId, PlanNodeId planNodeId) {
        return BasicWorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorId, planNodeId));
    }

    private AssignUniqueIdOperator(ProcessorContext context, WorkProcessor<Page> sourcePages, AtomicLong rowIdPool) {
        this.pages = sourcePages.transform(new AssignUniqueId(context.getTaskId(), rowIdPool));
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    private static class AssignUniqueId
    implements WorkProcessor.Transformation<Page, Page> {
        private final AtomicLong rowIdPool;
        private final long uniqueValueMask;
        private long rowIdCounter;
        private long maxRowIdCounterValue;

        private AssignUniqueId(TaskId taskId, AtomicLong rowIdPool) {
            this.rowIdPool = Objects.requireNonNull(rowIdPool, "rowIdPool is null");
            this.uniqueValueMask = (long)taskId.getStageId().getId() << 54 | (long)taskId.getId() << 40;
            this.requestValues();
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(@Nullable Page inputPage) {
            if (inputPage == null) {
                return WorkProcessor.TransformationState.finished();
            }
            return WorkProcessor.TransformationState.ofResult(inputPage.appendColumn(this.generateIdColumn(inputPage.getPositionCount())));
        }

        private Block generateIdColumn(int positionCount) {
            BlockBuilder block = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
            for (int currentPosition = 0; currentPosition < positionCount; ++currentPosition) {
                long rowId;
                if (this.rowIdCounter >= this.maxRowIdCounterValue) {
                    this.requestValues();
                }
                ++this.rowIdCounter;
                Verify.verify(((rowId & this.uniqueValueMask) == 0L ? 1 : 0) != 0, (String)"RowId and uniqueValue mask overlaps", (Object[])new Object[0]);
                BigintType.BIGINT.writeLong(block, this.uniqueValueMask | rowId);
            }
            return block.build();
        }

        private void requestValues() {
            this.rowIdCounter = this.rowIdPool.getAndAdd(0x100000L);
            this.maxRowIdCounterValue = Math.min(this.rowIdCounter + 0x100000L, 0x10000000000L);
            Preconditions.checkState((this.rowIdCounter < 0x10000000000L ? 1 : 0) != 0, (String)"Unique row id exceeds a limit: %s", (long)0x10000000000L);
        }
    }

    private static class Factory
    implements BasicWorkProcessorOperatorAdapter.BasicAdapterWorkProcessorOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private boolean closed;
        private final AtomicLong valuePool = new AtomicLong();

        private Factory(int operatorId, PlanNodeId planNodeId) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new AssignUniqueIdOperator(processorContext, sourcePages, this.valuePool);
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return AssignUniqueIdOperator.class.getSimpleName();
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public Factory duplicate() {
            return new Factory(this.operatorId, this.planNodeId);
        }
    }
}

