/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import io.airlift.concurrent.Threads;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceType;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.prestosql.client.NodeVersion;
import io.prestosql.connector.CatalogName;
import io.prestosql.failuredetector.FailureDetector;
import io.prestosql.metadata.AllNodes;
import io.prestosql.metadata.ForNodeManager;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.NodeState;
import io.prestosql.metadata.RemoteNodeState;
import io.prestosql.server.InternalCommunicationConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

@ThreadSafe
public final class DiscoveryNodeManager
implements InternalNodeManager {
    private static final Logger log = Logger.get(DiscoveryNodeManager.class);
    private static final Splitter CONNECTOR_ID_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final ServiceSelector serviceSelector;
    private final FailureDetector failureDetector;
    private final NodeVersion expectedNodeVersion;
    private final ConcurrentHashMap<String, RemoteNodeState> nodeStates = new ConcurrentHashMap();
    private final HttpClient httpClient;
    private final ScheduledExecutorService nodeStateUpdateExecutor;
    private final ExecutorService nodeStateEventExecutor;
    private final boolean httpsRequired;
    private final InternalNode currentNode;
    @GuardedBy(value="this")
    private SetMultimap<CatalogName, InternalNode> activeNodesByCatalogName;
    @GuardedBy(value="this")
    private AllNodes allNodes;
    @GuardedBy(value="this")
    private Set<InternalNode> coordinators;
    @GuardedBy(value="this")
    private final List<Consumer<AllNodes>> listeners = new ArrayList<Consumer<AllNodes>>();

    @Inject
    public DiscoveryNodeManager(@ServiceType(value="presto") ServiceSelector serviceSelector, NodeInfo nodeInfo, FailureDetector failureDetector, NodeVersion expectedNodeVersion, @ForNodeManager HttpClient httpClient, InternalCommunicationConfig internalCommunicationConfig) {
        this.serviceSelector = Objects.requireNonNull(serviceSelector, "serviceSelector is null");
        this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
        this.expectedNodeVersion = Objects.requireNonNull(expectedNodeVersion, "expectedNodeVersion is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.nodeStateUpdateExecutor = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"node-state-poller-%s"));
        this.nodeStateEventExecutor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"node-state-events-%s"));
        this.httpsRequired = internalCommunicationConfig.isHttpsRequired();
        this.currentNode = DiscoveryNodeManager.findCurrentNode(serviceSelector.selectAllServices(), Objects.requireNonNull(nodeInfo, "nodeInfo is null").getNodeId(), expectedNodeVersion, this.httpsRequired);
        this.refreshNodesInternal();
    }

    private static InternalNode findCurrentNode(List<ServiceDescriptor> allServices, String currentNodeId, NodeVersion expectedNodeVersion, boolean httpsRequired) {
        for (ServiceDescriptor service : allServices) {
            InternalNode node;
            URI uri = DiscoveryNodeManager.getHttpUri(service, httpsRequired);
            NodeVersion nodeVersion = DiscoveryNodeManager.getNodeVersion(service);
            if (uri == null || nodeVersion == null || !(node = new InternalNode(service.getNodeId(), uri, nodeVersion, DiscoveryNodeManager.isCoordinator(service))).getNodeIdentifier().equals(currentNodeId)) continue;
            Preconditions.checkState((boolean)node.getNodeVersion().equals((Object)expectedNodeVersion), (String)"INVARIANT: current node version (%s) should be equal to %s", (Object)node.getNodeVersion(), (Object)expectedNodeVersion);
            return node;
        }
        throw new IllegalStateException("INVARIANT: current node not returned from service selector");
    }

    @PostConstruct
    public void startPollingNodeStates() {
        this.nodeStateUpdateExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.pollWorkers();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error polling state of nodes");
            }
        }, 5L, 5L, TimeUnit.SECONDS);
        this.pollWorkers();
    }

    private void pollWorkers() {
        AllNodes allNodes = this.getAllNodes();
        ImmutableSet aliveNodes = ImmutableSet.builder().addAll(allNodes.getActiveNodes()).addAll(allNodes.getShuttingDownNodes()).build();
        ImmutableSet aliveNodeIds = (ImmutableSet)aliveNodes.stream().map(InternalNode::getNodeIdentifier).collect(ImmutableSet.toImmutableSet());
        ImmutableSet deadNodes = Sets.difference((Set)this.nodeStates.keySet(), (Set)aliveNodeIds).immutableCopy();
        ((ConcurrentHashMap.KeySetView)this.nodeStates.keySet()).removeAll((Collection)deadNodes);
        for (InternalNode node : aliveNodes) {
            this.nodeStates.putIfAbsent(node.getNodeIdentifier(), new RemoteNodeState(this.httpClient, HttpUriBuilder.uriBuilderFrom((URI)node.getInternalUri()).appendPath("/v1/info/state").build()));
        }
        this.nodeStates.values().forEach(RemoteNodeState::asyncRefresh);
        this.refreshNodesInternal();
    }

    @PreDestroy
    public void stop() {
        this.nodeStateUpdateExecutor.shutdownNow();
    }

    @Override
    public void refreshNodes() {
        this.refreshNodesInternal();
    }

    private synchronized void refreshNodesInternal() {
        Set services = (Set)this.serviceSelector.selectAllServices().stream().filter(service -> !this.failureDetector.getFailed().contains(service)).collect(ImmutableSet.toImmutableSet());
        ImmutableSet.Builder activeNodesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder inactiveNodesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder shuttingDownNodesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder coordinatorsBuilder = ImmutableSet.builder();
        ImmutableSetMultimap.Builder byConnectorIdBuilder = ImmutableSetMultimap.builder();
        block5: for (ServiceDescriptor service2 : services) {
            URI uri = DiscoveryNodeManager.getHttpUri(service2, this.httpsRequired);
            NodeVersion nodeVersion = DiscoveryNodeManager.getNodeVersion(service2);
            boolean coordinator = DiscoveryNodeManager.isCoordinator(service2);
            if (uri == null || nodeVersion == null) continue;
            InternalNode node = new InternalNode(service2.getNodeId(), uri, nodeVersion, coordinator);
            NodeState nodeState = this.getNodeState(node);
            switch (nodeState) {
                case ACTIVE: {
                    String connectorIds;
                    activeNodesBuilder.add((Object)node);
                    if (coordinator) {
                        coordinatorsBuilder.add((Object)node);
                    }
                    if ((connectorIds = (String)service2.getProperties().get("connectorIds")) != null) {
                        connectorIds = connectorIds.toLowerCase(Locale.ENGLISH);
                        for (String connectorId : CONNECTOR_ID_SPLITTER.split((CharSequence)connectorIds)) {
                            byConnectorIdBuilder.put((Object)new CatalogName(connectorId), (Object)node);
                        }
                    }
                    byConnectorIdBuilder.put((Object)new CatalogName("system"), (Object)node);
                    continue block5;
                }
                case INACTIVE: {
                    inactiveNodesBuilder.add((Object)node);
                    continue block5;
                }
                case SHUTTING_DOWN: {
                    shuttingDownNodesBuilder.add((Object)node);
                    continue block5;
                }
            }
            log.error("Unknown state %s for node %s", new Object[]{nodeState, node});
        }
        if (this.allNodes != null) {
            Sets.SetView missingNodes = Sets.difference(this.allNodes.getActiveNodes(), (Set)Sets.union((Set)activeNodesBuilder.build(), (Set)shuttingDownNodesBuilder.build()));
            for (InternalNode missingNode : missingNodes) {
                log.info("Previously active node is missing: %s (last seen at %s)", new Object[]{missingNode.getNodeIdentifier(), missingNode.getHost()});
            }
        }
        this.activeNodesByCatalogName = byConnectorIdBuilder.build();
        AllNodes allNodes = new AllNodes((Set<InternalNode>)activeNodesBuilder.build(), (Set<InternalNode>)inactiveNodesBuilder.build(), (Set<InternalNode>)shuttingDownNodesBuilder.build(), (Set<InternalNode>)coordinatorsBuilder.build());
        if (!allNodes.equals(this.allNodes)) {
            this.allNodes = allNodes;
            this.coordinators = coordinatorsBuilder.build();
            ImmutableList listeners = ImmutableList.copyOf(this.listeners);
            this.nodeStateEventExecutor.submit(() -> DiscoveryNodeManager.lambda$refreshNodesInternal$3((List)listeners, allNodes));
        }
    }

    private NodeState getNodeState(InternalNode node) {
        if (this.expectedNodeVersion.equals((Object)node.getNodeVersion())) {
            if (this.isNodeShuttingDown(node.getNodeIdentifier())) {
                return NodeState.SHUTTING_DOWN;
            }
            return NodeState.ACTIVE;
        }
        return NodeState.INACTIVE;
    }

    private boolean isNodeShuttingDown(String nodeId) {
        Optional remoteNodeState = this.nodeStates.containsKey(nodeId) ? this.nodeStates.get(nodeId).getNodeState() : Optional.empty();
        return remoteNodeState.isPresent() && remoteNodeState.get() == NodeState.SHUTTING_DOWN;
    }

    @Override
    public synchronized AllNodes getAllNodes() {
        return this.allNodes;
    }

    @Managed
    public int getActiveNodeCount() {
        return this.getAllNodes().getActiveNodes().size();
    }

    @Managed
    public int getInactiveNodeCount() {
        return this.getAllNodes().getInactiveNodes().size();
    }

    @Managed
    public int getShuttingDownNodeCount() {
        return this.getAllNodes().getShuttingDownNodes().size();
    }

    @Override
    public Set<InternalNode> getNodes(NodeState state) {
        switch (state) {
            case ACTIVE: {
                return this.getAllNodes().getActiveNodes();
            }
            case INACTIVE: {
                return this.getAllNodes().getInactiveNodes();
            }
            case SHUTTING_DOWN: {
                return this.getAllNodes().getShuttingDownNodes();
            }
        }
        throw new IllegalArgumentException("Unknown node state " + (Object)((Object)state));
    }

    @Override
    public synchronized Set<InternalNode> getActiveConnectorNodes(CatalogName catalogName) {
        return this.activeNodesByCatalogName.get((Object)catalogName);
    }

    @Override
    public InternalNode getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public synchronized Set<InternalNode> getCoordinators() {
        return this.coordinators;
    }

    @Override
    public synchronized void addNodeChangeListener(Consumer<AllNodes> listener) {
        this.listeners.add(Objects.requireNonNull(listener, "listener is null"));
        AllNodes allNodes = this.allNodes;
        this.nodeStateEventExecutor.submit(() -> listener.accept(allNodes));
    }

    @Override
    public synchronized void removeNodeChangeListener(Consumer<AllNodes> listener) {
        this.listeners.remove(Objects.requireNonNull(listener, "listener is null"));
    }

    private static URI getHttpUri(ServiceDescriptor descriptor, boolean httpsRequired) {
        String url = (String)descriptor.getProperties().get(httpsRequired ? "https" : "http");
        if (url != null) {
            try {
                return new URI(url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static NodeVersion getNodeVersion(ServiceDescriptor descriptor) {
        String nodeVersion = (String)descriptor.getProperties().get("node_version");
        return nodeVersion == null ? null : new NodeVersion(nodeVersion);
    }

    private static boolean isCoordinator(ServiceDescriptor service) {
        return Boolean.parseBoolean((String)service.getProperties().get("coordinator"));
    }

    private static /* synthetic */ void lambda$refreshNodesInternal$3(List listeners, AllNodes allNodes) {
        listeners.forEach(listener -> listener.accept(allNodes));
    }
}

