/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.stats.GcMonitor;
import io.airlift.units.DataSize;
import io.prestosql.ExceededMemoryLimitException;
import io.prestosql.ExceededSpillLimitException;
import io.prestosql.Session;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.memory.MemoryPool;
import io.prestosql.memory.QueryContextVisitor;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.MemoryReservationHandler;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.TaskContext;
import io.prestosql.spi.QueryId;
import io.prestosql.spiller.SpillSpaceTracker;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class QueryContext {
    private static final long GUARANTEED_MEMORY = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
    private final QueryId queryId;
    private final GcMonitor gcMonitor;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final long maxSpill;
    private final SpillSpaceTracker spillSpaceTracker;
    private final Map<TaskId, TaskContext> taskContexts = new ConcurrentHashMap<TaskId, TaskContext>();
    @GuardedBy(value="this")
    private long maxUserMemory;
    @GuardedBy(value="this")
    private long maxTotalMemory;
    private final MemoryTrackingContext queryMemoryContext;
    @GuardedBy(value="this")
    private MemoryPool memoryPool;
    @GuardedBy(value="this")
    private long spillUsed;

    public QueryContext(QueryId queryId, DataSize maxUserMemory, DataSize maxTotalMemory, MemoryPool memoryPool, GcMonitor gcMonitor, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, DataSize maxSpill, SpillSpaceTracker spillSpaceTracker) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.maxUserMemory = Objects.requireNonNull(maxUserMemory, "maxUserMemory is null").toBytes();
        this.maxTotalMemory = Objects.requireNonNull(maxTotalMemory, "maxTotalMemory is null").toBytes();
        this.memoryPool = Objects.requireNonNull(memoryPool, "memoryPool is null");
        this.gcMonitor = Objects.requireNonNull(gcMonitor, "gcMonitor is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
        this.maxSpill = Objects.requireNonNull(maxSpill, "maxSpill is null").toBytes();
        this.spillSpaceTracker = Objects.requireNonNull(spillSpaceTracker, "spillSpaceTracker is null");
        this.queryMemoryContext = new MemoryTrackingContext(AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)new QueryMemoryReservationHandler(this::updateUserMemory, this::tryUpdateUserMemory), (long)GUARANTEED_MEMORY), AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)new QueryMemoryReservationHandler(this::updateRevocableMemory, this::tryReserveMemoryNotSupported), (long)0L), AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)new QueryMemoryReservationHandler(this::updateSystemMemory, this::tryReserveMemoryNotSupported), (long)0L));
    }

    public synchronized void setResourceOvercommit() {
        this.maxUserMemory = this.memoryPool.getMaxBytes();
        this.maxTotalMemory = this.memoryPool.getMaxBytes();
    }

    @VisibleForTesting
    MemoryTrackingContext getQueryMemoryContext() {
        return this.queryMemoryContext;
    }

    private synchronized ListenableFuture<?> updateUserMemory(String allocationTag, long delta) {
        if (delta >= 0L) {
            this.enforceUserMemoryLimit(this.queryMemoryContext.getUserMemory(), delta, this.maxUserMemory);
            return this.memoryPool.reserve(this.queryId, allocationTag, delta);
        }
        this.memoryPool.free(this.queryId, allocationTag, -delta);
        return Operator.NOT_BLOCKED;
    }

    private synchronized ListenableFuture<?> updateRevocableMemory(String allocationTag, long delta) {
        if (delta >= 0L) {
            return this.memoryPool.reserveRevocable(this.queryId, delta);
        }
        this.memoryPool.freeRevocable(this.queryId, -delta);
        return Operator.NOT_BLOCKED;
    }

    private synchronized ListenableFuture<?> updateSystemMemory(String allocationTag, long delta) {
        long totalMemory = this.memoryPool.getQueryMemoryReservation(this.queryId);
        if (delta >= 0L) {
            this.enforceTotalMemoryLimit(totalMemory, delta, this.maxTotalMemory);
            return this.memoryPool.reserve(this.queryId, allocationTag, delta);
        }
        this.memoryPool.free(this.queryId, allocationTag, -delta);
        return Operator.NOT_BLOCKED;
    }

    public synchronized ListenableFuture<?> reserveSpill(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (this.spillUsed + bytes > this.maxSpill) {
            throw ExceededSpillLimitException.exceededPerQueryLocalLimit(DataSize.succinctBytes((long)this.maxSpill));
        }
        ListenableFuture<?> future = this.spillSpaceTracker.reserve(bytes);
        this.spillUsed += bytes;
        return future;
    }

    private synchronized boolean tryUpdateUserMemory(String allocationTag, long delta) {
        if (delta <= 0L) {
            ListenableFuture<?> future = this.updateUserMemory(allocationTag, delta);
            if (delta < 0L) {
                Verify.verify((boolean)future.isDone(), (String)"future should be done", (Object[])new Object[0]);
            }
            return true;
        }
        if (this.queryMemoryContext.getUserMemory() + delta > this.maxUserMemory) {
            return false;
        }
        return this.memoryPool.tryReserve(this.queryId, allocationTag, delta);
    }

    public synchronized void freeSpill(long bytes) {
        Preconditions.checkArgument((this.spillUsed - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.spillUsed -= bytes;
        this.spillSpaceTracker.free(bytes);
    }

    public synchronized void setMemoryPool(MemoryPool newMemoryPool) {
        Objects.requireNonNull(newMemoryPool, "newMemoryPool is null");
        if (this.memoryPool == newMemoryPool) {
            return;
        }
        ListenableFuture<?> future = this.memoryPool.moveQuery(this.queryId, newMemoryPool);
        this.memoryPool = newMemoryPool;
        future.addListener(() -> this.taskContexts.values().forEach(TaskContext::moreMemoryAvailable), MoreExecutors.directExecutor());
    }

    public synchronized void setMaxUserMemory(long maxUserMemory) {
        this.maxUserMemory = maxUserMemory;
    }

    public synchronized void setMaxTotalMemory(long maxTotalMemory) {
        this.maxTotalMemory = maxTotalMemory;
    }

    public synchronized MemoryPool getMemoryPool() {
        return this.memoryPool;
    }

    public TaskContext addTaskContext(TaskStateMachine taskStateMachine, Session session, boolean perOperatorCpuTimerEnabled, boolean cpuTimerEnabled, OptionalInt totalPartitions) {
        TaskContext taskContext = TaskContext.createTaskContext(this, taskStateMachine, this.gcMonitor, this.notificationExecutor, this.yieldExecutor, session, this.queryMemoryContext.newMemoryTrackingContext(), perOperatorCpuTimerEnabled, cpuTimerEnabled, totalPartitions);
        this.taskContexts.put(taskStateMachine.getTaskId(), taskContext);
        return taskContext;
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitQueryContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.taskContexts.values().stream().map(taskContext -> taskContext.accept(visitor, context)).collect(Collectors.toList());
    }

    public TaskContext getTaskContextByTaskId(TaskId taskId) {
        TaskContext taskContext = this.taskContexts.get(taskId);
        return (TaskContext)Verify.verifyNotNull((Object)taskContext, (String)"task does not exist", (Object[])new Object[0]);
    }

    private boolean tryReserveMemoryNotSupported(String allocationTag, long bytes) {
        throw new UnsupportedOperationException("tryReserveMemory is not supported");
    }

    @GuardedBy(value="this")
    private void enforceUserMemoryLimit(long allocated, long delta, long maxMemory) {
        if (allocated + delta > maxMemory) {
            throw ExceededMemoryLimitException.exceededLocalUserMemoryLimit(DataSize.succinctBytes((long)maxMemory), this.getAdditionalFailureInfo(allocated, delta));
        }
    }

    @GuardedBy(value="this")
    private void enforceTotalMemoryLimit(long allocated, long delta, long maxMemory) {
        if (allocated + delta > maxMemory) {
            throw ExceededMemoryLimitException.exceededLocalTotalMemoryLimit(DataSize.succinctBytes((long)maxMemory), this.getAdditionalFailureInfo(allocated, delta));
        }
    }

    @GuardedBy(value="this")
    private String getAdditionalFailureInfo(long allocated, long delta) {
        Map<String, Long> queryAllocations = this.memoryPool.getTaggedMemoryAllocations().get(this.queryId);
        String additionalInfo = String.format("Allocated: %s, Delta: %s", DataSize.succinctBytes((long)allocated), DataSize.succinctBytes((long)delta));
        if (queryAllocations == null) {
            return additionalInfo;
        }
        String topConsumers = ((ImmutableMap)queryAllocations.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(3L).filter(e -> (Long)e.getValue() >= 0L).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> DataSize.succinctBytes((long)((Long)e.getValue()))))).toString();
        return String.format("%s, Top Consumers: %s", additionalInfo, topConsumers);
    }

    private static class QueryMemoryReservationHandler
    implements MemoryReservationHandler {
        private final BiFunction<String, Long, ListenableFuture<?>> reserveMemoryFunction;
        private final BiPredicate<String, Long> tryReserveMemoryFunction;

        public QueryMemoryReservationHandler(BiFunction<String, Long, ListenableFuture<?>> reserveMemoryFunction, BiPredicate<String, Long> tryReserveMemoryFunction) {
            this.reserveMemoryFunction = Objects.requireNonNull(reserveMemoryFunction, "reserveMemoryFunction is null");
            this.tryReserveMemoryFunction = Objects.requireNonNull(tryReserveMemoryFunction, "tryReserveMemoryFunction is null");
        }

        public ListenableFuture<?> reserveMemory(String allocationTag, long delta) {
            return this.reserveMemoryFunction.apply(allocationTag, delta);
        }

        public boolean tryReserveMemory(String allocationTag, long delta) {
            return this.tryReserveMemoryFunction.test(allocationTag, delta);
        }
    }
}

