/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import com.google.common.base.MoreObjects;
import io.prestosql.memory.MemoryInfo;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.memory.MemoryPoolId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface LowMemoryKiller {
    public Optional<QueryId> chooseQueryToKill(List<QueryMemoryInfo> var1, List<MemoryInfo> var2);

    public static class QueryMemoryInfo {
        private final QueryId queryId;
        private final MemoryPoolId memoryPoolId;
        private final long memoryReservation;

        public QueryMemoryInfo(QueryId queryId, MemoryPoolId memoryPoolId, long memoryReservation) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.memoryPoolId = Objects.requireNonNull(memoryPoolId, "memoryPoolId is null");
            this.memoryReservation = memoryReservation;
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public MemoryPoolId getMemoryPoolId() {
            return this.memoryPoolId;
        }

        public long getMemoryReservation() {
            return this.memoryReservation;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("memoryPoolId", (Object)this.memoryPoolId).add("memoryReservation", this.memoryReservation).toString();
        }
    }
}

