/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.memory;

import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.memory.MemoryPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

public final class LocalMemoryManagerExporter {
    private final MBeanExporter exporter;
    @GuardedBy(value="this")
    private final List<MemoryPool> pools = new ArrayList<MemoryPool>();

    @Inject
    public LocalMemoryManagerExporter(LocalMemoryManager memoryManager, MBeanExporter exporter) {
        this.exporter = Objects.requireNonNull(exporter, "exporter is null");
        for (MemoryPool pool : memoryManager.getPools()) {
            this.addPool(pool);
        }
    }

    private synchronized void addPool(MemoryPool pool) {
        try {
            this.exporter.exportWithGeneratedName((Object)pool, MemoryPool.class, pool.getId().toString());
            this.pools.add(pool);
        }
        catch (JmxException jmxException) {
            // empty catch block
        }
    }

    @PreDestroy
    public synchronized void destroy() {
        for (MemoryPool pool : this.pools) {
            String objectName = ObjectNames.builder(MemoryPool.class, (String)pool.getId().toString()).build();
            try {
                this.exporter.unexport(objectName);
            }
            catch (JmxException jmxException) {}
        }
        this.pools.clear();
    }
}

