/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.ExceededCpuLimitException;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.event.QueryMonitor;
import io.prestosql.execution.QueryExecution;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryManager;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.execution.QueryManagerStats;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.QueryTracker;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StateMachine;
import io.prestosql.memory.ClusterMemoryManager;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.protocol.Slug;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.planner.Plan;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class SqlQueryManager
implements QueryManager {
    private static final Logger log = Logger.get(SqlQueryManager.class);
    private final ClusterMemoryManager memoryManager;
    private final QueryMonitor queryMonitor;
    private final QueryTracker<QueryExecution> queryTracker;
    private final Duration maxQueryCpuTime;
    private final ExecutorService queryExecutor;
    private final ThreadPoolExecutorMBean queryExecutorMBean;
    private final ScheduledExecutorService queryManagementExecutor;
    private final ThreadPoolExecutorMBean queryManagementExecutorMBean;
    private final QueryManagerStats stats = new QueryManagerStats();

    @Inject
    public SqlQueryManager(ClusterMemoryManager memoryManager, QueryMonitor queryMonitor, QueryManagerConfig queryManagerConfig) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.maxQueryCpuTime = queryManagerConfig.getQueryMaxCpuTime();
        this.queryExecutor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-scheduler-%s"));
        this.queryExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.queryExecutor);
        this.queryManagementExecutor = Executors.newScheduledThreadPool(queryManagerConfig.getQueryManagerExecutorPoolSize(), Threads.threadsNamed((String)"query-management-%s"));
        this.queryManagementExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)this.queryManagementExecutor));
        this.queryTracker = new QueryTracker(queryManagerConfig, this.queryManagementExecutor);
    }

    @PostConstruct
    public void start() {
        this.queryTracker.start();
        this.queryManagementExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.enforceMemoryLimits();
            }
            catch (Throwable e) {
                log.error(e, "Error enforcing memory limits");
            }
            try {
                this.enforceCpuLimits();
            }
            catch (Throwable e) {
                log.error(e, "Error enforcing query CPU time limits");
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryTracker.stop();
        this.queryManagementExecutor.shutdownNow();
        this.queryExecutor.shutdownNow();
    }

    @Override
    public List<BasicQueryInfo> getQueries() {
        return (List)this.queryTracker.getAllQueries().stream().map(queryExecution -> {
            try {
                return queryExecution.getBasicQueryInfo();
            }
            catch (RuntimeException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void addOutputInfoListener(QueryId queryId, Consumer<QueryExecution.QueryOutputInfo> listener) {
        Objects.requireNonNull(listener, "listener is null");
        this.queryTracker.getQuery(queryId).addOutputInfoListener(listener);
    }

    @Override
    public void addStateChangeListener(QueryId queryId, StateMachine.StateChangeListener<QueryState> listener) {
        Objects.requireNonNull(listener, "listener is null");
        this.queryTracker.getQuery(queryId).addStateChangeListener(listener);
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryId queryId, QueryState currentState) {
        return this.queryTracker.tryGetQuery(queryId).map(query -> query.getStateChange(currentState)).orElseGet(() -> Futures.immediateFailedFuture((Throwable)new NoSuchElementException()));
    }

    @Override
    public BasicQueryInfo getQueryInfo(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getBasicQueryInfo();
    }

    @Override
    public QueryInfo getFullQueryInfo(QueryId queryId) throws NoSuchElementException {
        return this.queryTracker.getQuery(queryId).getQueryInfo();
    }

    @Override
    public Session getQuerySession(QueryId queryId) throws NoSuchElementException {
        return this.queryTracker.getQuery(queryId).getSession();
    }

    @Override
    public Slug getQuerySlug(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getSlug();
    }

    public Plan getQueryPlan(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getQueryPlan();
    }

    public void addFinalQueryInfoListener(QueryId queryId, StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.queryTracker.getQuery(queryId).addFinalQueryInfoListener(stateChangeListener);
    }

    @Override
    public QueryState getQueryState(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getState();
    }

    @Override
    public void recordHeartbeat(QueryId queryId) {
        this.queryTracker.tryGetQuery(queryId).ifPresent(QueryExecution::recordHeartbeat);
    }

    @Override
    public void createQuery(QueryExecution queryExecution) {
        Objects.requireNonNull(queryExecution, "queryExecution is null");
        if (!this.queryTracker.addQuery(queryExecution)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Query %s already registered", queryExecution.getQueryId()));
        }
        queryExecution.addFinalQueryInfoListener(finalQueryInfo -> {
            try {
                this.queryMonitor.queryCompletedEvent((QueryInfo)finalQueryInfo);
            }
            finally {
                this.queryTracker.expireQuery(queryExecution.getQueryId());
            }
        });
        this.stats.trackQueryStats(queryExecution);
        queryExecution.start();
    }

    @Override
    public void failQuery(QueryId queryId, Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.queryTracker.tryGetQuery(queryId).ifPresent(query -> query.fail(cause));
    }

    @Override
    public void cancelQuery(QueryId queryId) {
        log.debug("Cancel query %s", new Object[]{queryId});
        this.queryTracker.tryGetQuery(queryId).ifPresent(QueryExecution::cancelQuery);
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        log.debug("Cancel stage %s", new Object[]{stageId});
        this.queryTracker.tryGetQuery(stageId.getQueryId()).ifPresent(query -> query.cancelStage(stageId));
    }

    @Override
    @Managed
    @Flatten
    public QueryManagerStats getStats() {
        return this.stats;
    }

    @Managed(description="Query scheduler executor")
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.queryExecutorMBean;
    }

    @Managed(description="Query query management executor")
    @Nested
    public ThreadPoolExecutorMBean getManagementExecutor() {
        return this.queryManagementExecutorMBean;
    }

    private void enforceMemoryLimits() {
        List runningQueries = (List)this.queryTracker.getAllQueries().stream().filter(query -> query.getState() == QueryState.RUNNING).collect(ImmutableList.toImmutableList());
        this.memoryManager.process(runningQueries, this::getQueries);
    }

    private void enforceCpuLimits() {
        for (QueryExecution query : this.queryTracker.getAllQueries()) {
            Duration cpuTime = query.getTotalCpuTime();
            Duration sessionLimit = SystemSessionProperties.getQueryMaxCpuTime(query.getSession());
            Duration limit = (Duration)Ordering.natural().min((Object)this.maxQueryCpuTime, (Object)sessionLimit);
            if (cpuTime.compareTo(limit) <= 0) continue;
            query.fail((Throwable)((Object)new ExceededCpuLimitException(limit)));
        }
    }
}

