/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.Comment;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class CommentTask
implements DataDefinitionTask<Comment> {
    @Override
    public String getName() {
        return "COMMENT";
    }

    @Override
    public ListenableFuture<?> execute(Comment statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Optional<TableHandle> tableHandle;
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        if (statement.getType() == Comment.Type.TABLE) {
            tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
            tableHandle = metadata.getTableHandle(session, tableName);
            if (!tableHandle.isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: %s", tableName);
            }
        } else {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Unsupported comment type: %s", statement.getType());
        }
        accessControl.checkCanSetTableComment(session.toSecurityContext(), tableName);
        metadata.setTableComment(session, tableHandle.get(), statement.getComment());
        return Futures.immediateFuture(null);
    }
}

