/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.airlift.log.Logger;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.execution.TaskId;
import io.prestosql.operator.DriverStats;
import io.prestosql.spi.eventlistener.SplitCompletedEvent;
import io.prestosql.spi.eventlistener.SplitFailureInfo;
import io.prestosql.spi.eventlistener.SplitStatistics;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class SplitMonitor {
    private static final Logger log = Logger.get(SplitMonitor.class);
    private final ObjectMapper objectMapper;
    private final EventListenerManager eventListenerManager;

    @Inject
    public SplitMonitor(EventListenerManager eventListenerManager, ObjectMapper objectMapper) {
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
    }

    public void splitCompletedEvent(TaskId taskId, DriverStats driverStats) {
        this.splitCompletedEvent(taskId, driverStats, null, null);
    }

    public void splitFailedEvent(TaskId taskId, DriverStats driverStats, Throwable cause) {
        this.splitCompletedEvent(taskId, driverStats, cause.getClass().getName(), cause.getMessage());
    }

    private void splitCompletedEvent(TaskId taskId, DriverStats driverStats, @Nullable String failureType, @Nullable String failureMessage) {
        Duration queuedTime = Duration.ofMillis(driverStats.getQueuedTime().toMillis());
        Optional<Object> queuedTimeIfSplitRan = Optional.empty();
        if (driverStats.getStartTime() != null) {
            queuedTimeIfSplitRan = Optional.of(queuedTime);
        }
        Duration elapsedTime = Duration.ofMillis(driverStats.getElapsedTime().toMillis());
        Optional<Object> elapsedTimeIfSplitRan = Optional.empty();
        if (driverStats.getEndTime() != null) {
            elapsedTimeIfSplitRan = Optional.of(elapsedTime);
        }
        Optional<Object> splitFailureMetadata = Optional.empty();
        if (failureType != null) {
            splitFailureMetadata = Optional.of(new SplitFailureInfo(failureType, failureMessage != null ? failureMessage : ""));
        }
        try {
            this.eventListenerManager.splitCompleted(new SplitCompletedEvent(taskId.getQueryId().toString(), taskId.getStageId().toString(), Integer.toString(taskId.getId()), driverStats.getCreateTime().toDate().toInstant(), Optional.ofNullable(driverStats.getStartTime()).map(startTime -> startTime.toDate().toInstant()), Optional.ofNullable(driverStats.getEndTime()).map(endTime -> endTime.toDate().toInstant()), new SplitStatistics(Duration.ofMillis(driverStats.getTotalCpuTime().toMillis()), elapsedTime, queuedTime, Duration.ofMillis(driverStats.getRawInputReadTime().toMillis()), driverStats.getRawInputPositions(), driverStats.getRawInputDataSize().toBytes(), queuedTimeIfSplitRan, elapsedTimeIfSplitRan), splitFailureMetadata, this.objectMapper.writeValueAsString((Object)driverStats)));
        }
        catch (JsonProcessingException e) {
            log.error((Throwable)e, "Error processing split completion event for task %s", new Object[]{taskId});
        }
    }
}

