/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import io.prestosql.Session;
import io.prestosql.cost.FilterStatsCalculator;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.SimpleStatsRule;
import io.prestosql.cost.StatsNormalizer;
import io.prestosql.cost.StatsProvider;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import java.util.Objects;
import java.util.Optional;

public class SpatialJoinStatsRule
extends SimpleStatsRule<SpatialJoinNode> {
    private static final Pattern<SpatialJoinNode> PATTERN = Patterns.spatialJoin();
    private final FilterStatsCalculator statsCalculator;

    public SpatialJoinStatsRule(FilterStatsCalculator statsCalculator, StatsNormalizer normalizer) {
        super(normalizer);
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(SpatialJoinNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate leftStats = sourceStats.getStats(node.getLeft());
        PlanNodeStatsEstimate rightStats = sourceStats.getStats(node.getRight());
        PlanNodeStatsEstimate crossJoinStats = this.crossJoinStats(node, leftStats, rightStats);
        switch (node.getType()) {
            case INNER: {
                return Optional.of(this.statsCalculator.filterStats(crossJoinStats, node.getFilter(), session, types));
            }
            case LEFT: {
                return Optional.of(PlanNodeStatsEstimate.unknown());
            }
        }
        throw new IllegalArgumentException("Unknown spatial join type: " + (Object)((Object)node.getType()));
    }

    private PlanNodeStatsEstimate crossJoinStats(SpatialJoinNode node, PlanNodeStatsEstimate leftStats, PlanNodeStatsEstimate rightStats) {
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder().setOutputRowCount(leftStats.getOutputRowCount() * rightStats.getOutputRowCount());
        node.getLeft().getOutputSymbols().forEach(symbol -> builder.addSymbolStatistics((Symbol)symbol, leftStats.getSymbolStatistics((Symbol)symbol)));
        node.getRight().getOutputSymbols().forEach(symbol -> builder.addSymbolStatistics((Symbol)symbol, rightStats.getSymbolStatistics((Symbol)symbol)));
        return builder.build();
    }

    @Override
    public Pattern<SpatialJoinNode> getPattern() {
        return PATTERN;
    }
}

