/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.connector.system.SystemTablesProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class StaticSystemTablesProvider
implements SystemTablesProvider {
    private final Set<SystemTable> systemTables;
    private final Map<SchemaTableName, SystemTable> systemTablesMap;

    public StaticSystemTablesProvider(Set<SystemTable> systemTables) {
        this.systemTables = ImmutableSet.copyOf(systemTables);
        this.systemTablesMap = (Map)systemTables.stream().collect(ImmutableMap.toImmutableMap(table -> table.getTableMetadata().getTable(), Function.identity()));
    }

    @Override
    public Set<SystemTable> listSystemTables(ConnectorSession session) {
        return this.systemTables;
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return Optional.ofNullable(this.systemTablesMap.get(tableName));
    }
}

