/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.informationschema;

import io.airlift.log.Logger;
import io.prestosql.FullConnectorSession;
import io.prestosql.connector.informationschema.InformationSchemaPageSource;
import io.prestosql.connector.informationschema.InformationSchemaTableHandle;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;

public class InformationSchemaPageSourceProvider
implements ConnectorPageSourceProvider {
    private static final Logger log = Logger.get(InformationSchemaPageSourceProvider.class);
    private final Metadata metadata;
    private final AccessControl accessControl;

    public InformationSchemaPageSourceProvider(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, TupleDomain<ColumnHandle> dynamicFilter) {
        InformationSchemaTableHandle informationSchemaTableHandle = (InformationSchemaTableHandle)tableHandle;
        log.debug("Building information schema table (queryId=%s; tableHandle=%s)", new Object[]{session.getQueryId(), informationSchemaTableHandle});
        return new InformationSchemaPageSource(((FullConnectorSession)session).getSession(), this.metadata, this.accessControl, (InformationSchemaTableHandle)tableHandle, columns);
    }
}

