/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.BytecodeVisitor;
import io.airlift.bytecode.Comment;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.OpCode;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.debug.LineNumberNode;
import io.airlift.bytecode.instruction.Constant;
import io.airlift.bytecode.instruction.FieldInstruction;
import io.airlift.bytecode.instruction.InvokeInstruction;
import io.airlift.bytecode.instruction.JumpInstruction;
import io.airlift.bytecode.instruction.LabelNode;
import io.airlift.bytecode.instruction.TypeInstruction;
import io.airlift.bytecode.instruction.VariableInstruction;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.MethodVisitor;

@NotThreadSafe
public class BytecodeBlock
implements BytecodeNode {
    private final List<BytecodeNode> nodes = new ArrayList<BytecodeNode>();
    private String description;
    private int currentLineNumber = -1;

    public String getDescription() {
        return this.description;
    }

    public BytecodeBlock setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.copyOf(this.nodes);
    }

    public BytecodeBlock append(BytecodeNode node) {
        this.nodes.add(node);
        return this;
    }

    public BytecodeBlock comment(String comment) {
        this.nodes.add(new Comment(comment));
        return this;
    }

    public BytecodeBlock comment(String comment, Object ... args) {
        this.nodes.add(new Comment(String.format(comment, args)));
        return this;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public BytecodeBlock visitLabel(LabelNode label) {
        this.nodes.add(label);
        return this;
    }

    public BytecodeBlock gotoLabel(LabelNode label) {
        this.nodes.add(JumpInstruction.jump(label));
        return this;
    }

    public BytecodeBlock ifFalseGoto(LabelNode label) {
        return this.ifZeroGoto(label);
    }

    public BytecodeBlock ifTrueGoto(LabelNode label) {
        return this.ifNotZeroGoto(label);
    }

    public BytecodeBlock ifZeroGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfEqualZero(label));
        return this;
    }

    public BytecodeBlock ifNotZeroGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfNotEqualZero(label));
        return this;
    }

    public BytecodeBlock ifNullGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfNull(label));
        return this;
    }

    public BytecodeBlock ifNotNullGoto(LabelNode label) {
        this.nodes.add(JumpInstruction.jumpIfNotNull(label));
        return this;
    }

    public BytecodeBlock intAdd() {
        this.nodes.add(OpCode.IADD);
        return this;
    }

    public BytecodeBlock longAdd() {
        this.nodes.add(OpCode.LADD);
        return this;
    }

    public BytecodeBlock longCompare() {
        this.nodes.add(OpCode.LCMP);
        return this;
    }

    public BytecodeBlock doubleCompareNanLess() {
        this.nodes.add(OpCode.DCMPL);
        return this;
    }

    public BytecodeBlock doubleCompareNanGreater() {
        this.nodes.add(OpCode.DCMPG);
        return this;
    }

    public BytecodeBlock intLeftShift() {
        this.nodes.add(OpCode.ISHL);
        return this;
    }

    public BytecodeBlock intRightShift() {
        this.nodes.add(OpCode.ISHR);
        return this;
    }

    public BytecodeBlock longLeftShift() {
        this.nodes.add(OpCode.LSHL);
        return this;
    }

    public BytecodeBlock longRightShift() {
        this.nodes.add(OpCode.LSHR);
        return this;
    }

    public BytecodeBlock unsignedIntRightShift() {
        this.nodes.add(OpCode.IUSHR);
        return this;
    }

    public BytecodeBlock unsignedLongRightShift() {
        this.nodes.add(OpCode.LUSHR);
        return this;
    }

    public BytecodeBlock intBitAnd() {
        this.nodes.add(OpCode.IAND);
        return this;
    }

    public BytecodeBlock intBitOr() {
        this.nodes.add(OpCode.IOR);
        return this;
    }

    public BytecodeBlock intBitXor() {
        this.nodes.add(OpCode.IXOR);
        return this;
    }

    public BytecodeBlock longBitAnd() {
        this.nodes.add(OpCode.LAND);
        return this;
    }

    public BytecodeBlock longBitOr() {
        this.nodes.add(OpCode.LOR);
        return this;
    }

    public BytecodeBlock longBitXor() {
        this.nodes.add(OpCode.LXOR);
        return this;
    }

    public BytecodeBlock intNegate() {
        this.nodes.add(OpCode.INEG);
        return this;
    }

    public BytecodeBlock intToLong() {
        this.nodes.add(OpCode.I2L);
        return this;
    }

    public BytecodeBlock longNegate() {
        this.nodes.add(OpCode.LNEG);
        return this;
    }

    public BytecodeBlock longToInt() {
        this.nodes.add(OpCode.L2I);
        return this;
    }

    public BytecodeBlock isInstanceOf(Class<?> type) {
        this.nodes.add(TypeInstruction.instanceOf(type));
        return this;
    }

    public BytecodeBlock isInstanceOf(ParameterizedType type) {
        this.nodes.add(TypeInstruction.instanceOf(type));
        return this;
    }

    public BytecodeBlock checkCast(Class<?> type) {
        this.nodes.add(TypeInstruction.cast(type));
        return this;
    }

    public BytecodeBlock checkCast(ParameterizedType type) {
        this.nodes.add(TypeInstruction.cast(type));
        return this;
    }

    public BytecodeBlock invokeStatic(Method method) {
        this.nodes.add(InvokeInstruction.invokeStatic(method));
        return this;
    }

    public BytecodeBlock invokeStatic(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeStatic(method));
        return this;
    }

    public BytecodeBlock invokeStatic(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeStatic(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeStatic(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeStatic(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeStatic(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeVirtual(Method method) {
        this.nodes.add(InvokeInstruction.invokeVirtual(method));
        return this;
    }

    public BytecodeBlock invokeVirtual(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeVirtual(method));
        return this;
    }

    public BytecodeBlock invokeVirtual(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeVirtual(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeVirtual(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeVirtual(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeVirtual(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeInterface(Method method) {
        this.nodes.add(InvokeInstruction.invokeInterface(method));
        return this;
    }

    public BytecodeBlock invokeInterface(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeInterface(method));
        return this;
    }

    public BytecodeBlock invokeInterface(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeInterface(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeInterface(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeInterface(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeInterface(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeConstructor(Constructor<?> constructor) {
        this.nodes.add(InvokeInstruction.invokeConstructor(constructor));
        return this;
    }

    public BytecodeBlock invokeConstructor(Class<?> type, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeConstructor(Class<?> type, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeConstructor(ParameterizedType type, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeConstructor(ParameterizedType type, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeConstructor(type, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeSpecial(Method method) {
        this.nodes.add(InvokeInstruction.invokeSpecial(method));
        return this;
    }

    public BytecodeBlock invokeSpecial(MethodDefinition method) {
        this.nodes.add(InvokeInstruction.invokeSpecial(method));
        return this;
    }

    public BytecodeBlock invokeSpecial(Class<?> type, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeSpecial(Class<?> type, String name, Class<?> returnType, Iterable<Class<?>> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeSpecial(ParameterizedType type, String name, ParameterizedType returnType, ParameterizedType ... parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeSpecial(ParameterizedType type, String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes) {
        this.nodes.add(InvokeInstruction.invokeSpecial(type, name, returnType, parameterTypes));
        return this;
    }

    public BytecodeBlock invokeDynamic(String name, MethodType methodType, Method bootstrapMethod, Object ... defaultBootstrapArguments) {
        this.nodes.add(InvokeInstruction.invokeDynamic(name, methodType, bootstrapMethod, defaultBootstrapArguments));
        return this;
    }

    public BytecodeNode invokeDynamic(String name, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Method bootstrapMethod, List<Object> bootstrapArgs) {
        this.nodes.add(InvokeInstruction.invokeDynamic(name, returnType, parameterTypes, bootstrapMethod, bootstrapArgs));
        return this;
    }

    public BytecodeBlock ret(Class<?> type) {
        if (type == Long.TYPE) {
            this.retLong();
        } else if (type == Boolean.TYPE) {
            this.retBoolean();
        } else if (type == Integer.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
            this.retInt();
        } else if (type == Float.TYPE) {
            this.retFloat();
        } else if (type == Double.TYPE) {
            this.retDouble();
        } else if (type == Void.TYPE) {
            this.ret();
        } else if (!type.isPrimitive()) {
            this.retObject();
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type.getName());
        }
        return this;
    }

    public BytecodeBlock ret() {
        this.nodes.add(OpCode.RETURN);
        return this;
    }

    public BytecodeBlock retObject() {
        this.nodes.add(OpCode.ARETURN);
        return this;
    }

    public BytecodeBlock retFloat() {
        this.nodes.add(OpCode.FRETURN);
        return this;
    }

    public BytecodeBlock retDouble() {
        this.nodes.add(OpCode.DRETURN);
        return this;
    }

    public BytecodeBlock retBoolean() {
        this.nodes.add(OpCode.IRETURN);
        return this;
    }

    public BytecodeBlock retLong() {
        this.nodes.add(OpCode.LRETURN);
        return this;
    }

    public BytecodeBlock retInt() {
        this.nodes.add(OpCode.IRETURN);
        return this;
    }

    public BytecodeBlock throwObject() {
        this.nodes.add(OpCode.ATHROW);
        return this;
    }

    public BytecodeBlock newObject(Class<?> type) {
        this.nodes.add(TypeInstruction.newObject(type));
        return this;
    }

    public BytecodeBlock newObject(ParameterizedType type) {
        this.nodes.add(TypeInstruction.newObject(type));
        return this;
    }

    public BytecodeBlock newArray(Class<?> type) {
        this.nodes.add(TypeInstruction.newObjectArray(type));
        return this;
    }

    public BytecodeBlock dup() {
        this.nodes.add(OpCode.DUP);
        return this;
    }

    public BytecodeBlock dup(Class<?> type) {
        if (type == Long.TYPE || type == Double.TYPE) {
            this.nodes.add(OpCode.DUP2);
        } else if (type != Void.TYPE) {
            this.nodes.add(OpCode.DUP);
        }
        return this;
    }

    public BytecodeBlock pop() {
        this.nodes.add(OpCode.POP);
        return this;
    }

    public BytecodeBlock pop(Class<?> type) {
        if (type == Long.TYPE || type == Double.TYPE) {
            this.nodes.add(OpCode.POP2);
        } else if (type != Void.TYPE) {
            this.nodes.add(OpCode.POP);
        }
        return this;
    }

    public BytecodeBlock pop(ParameterizedType type) {
        Class<?> primitiveType = type.getPrimitiveType();
        if (primitiveType == Long.TYPE || primitiveType == Double.TYPE) {
            this.nodes.add(OpCode.POP2);
        } else if (primitiveType != Void.TYPE) {
            this.nodes.add(OpCode.POP);
        }
        return this;
    }

    public BytecodeBlock swap() {
        this.nodes.add(OpCode.SWAP);
        return this;
    }

    public BytecodeBlock getField(Field field) {
        return this.getField(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public BytecodeBlock getField(FieldDefinition field) {
        this.getField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public BytecodeBlock getField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.getField(ParameterizedType.type(target), fieldName, ParameterizedType.type(fieldType));
        return this;
    }

    public BytecodeBlock getField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.getFieldInstruction(target, fieldName, fieldType));
        return this;
    }

    public BytecodeBlock putField(Field field) {
        return this.putField(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public BytecodeBlock putField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.putField(ParameterizedType.type(target), fieldName, ParameterizedType.type(fieldType));
        return this;
    }

    public BytecodeBlock putField(FieldDefinition field) {
        Preconditions.checkArgument((!field.getAccess().contains((Object)Access.STATIC) ? 1 : 0) != 0, (String)"Field is static: %s", (Object)field);
        this.putField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public BytecodeBlock putField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.putFieldInstruction(target, fieldName, fieldType));
        return this;
    }

    public BytecodeBlock getStaticField(FieldDefinition field) {
        this.getStaticField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public BytecodeBlock getStaticField(Field field) {
        Preconditions.checkArgument((boolean)Modifier.isStatic(field.getModifiers()), (String)"Field is not static: %s", (Object)field);
        this.getStaticField(ParameterizedType.type(field.getDeclaringClass()), field.getName(), ParameterizedType.type(field.getType()));
        return this;
    }

    public BytecodeBlock getStaticField(Class<?> target, String fieldName, Class<?> fieldType) {
        this.nodes.add(FieldInstruction.getStaticInstruction(target, fieldName, fieldType));
        return this;
    }

    public BytecodeBlock getStaticField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.getStaticInstruction(target, fieldName, fieldType));
        return this;
    }

    public BytecodeBlock getStaticField(ParameterizedType target, FieldDefinition field) {
        this.nodes.add(FieldInstruction.getStaticInstruction(target, field.getName(), field.getType()));
        return this;
    }

    public BytecodeBlock putStaticField(FieldDefinition field) {
        this.putStaticField(field.getDeclaringClass().getType(), field.getName(), field.getType());
        return this;
    }

    public BytecodeBlock putStaticField(ParameterizedType target, FieldDefinition field) {
        Preconditions.checkArgument((boolean)field.getAccess().contains((Object)Access.STATIC), (String)"Field is not static: %s", (Object)field);
        this.putStaticField(target, field.getName(), field.getType());
        return this;
    }

    public BytecodeBlock putStaticField(ParameterizedType target, String fieldName, ParameterizedType fieldType) {
        this.nodes.add(FieldInstruction.putStaticInstruction(target, fieldName, fieldType));
        return this;
    }

    public BytecodeBlock pushNull() {
        this.nodes.add(OpCode.ACONST_NULL);
        return this;
    }

    public BytecodeBlock push(Class<?> type) {
        this.nodes.add(Constant.loadClass(type));
        return this;
    }

    public BytecodeBlock push(ParameterizedType type) {
        this.nodes.add(Constant.loadClass(type));
        return this;
    }

    public BytecodeBlock push(String value) {
        this.nodes.add(Constant.loadString(value));
        return this;
    }

    public BytecodeBlock push(Number value) {
        this.nodes.add(Constant.loadNumber(value));
        return this;
    }

    public BytecodeBlock push(int value) {
        this.nodes.add(Constant.loadInt(value));
        return this;
    }

    public BytecodeBlock push(boolean value) {
        this.nodes.add(Constant.loadBoolean(value));
        return this;
    }

    public BytecodeBlock pushJavaDefault(Class<?> type) {
        if (type == Void.TYPE) {
            return this;
        }
        if (type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE || type == Integer.TYPE) {
            return this.push(0);
        }
        if (type == Long.TYPE) {
            return this.push(0L);
        }
        if (type == Float.TYPE) {
            return this.push(Float.valueOf(0.0f));
        }
        if (type == Double.TYPE) {
            return this.push(0.0);
        }
        return this.pushNull();
    }

    public BytecodeBlock initializeVariable(Variable variable) {
        ParameterizedType type = variable.getType();
        if (type.getType().length() == 1) {
            switch (type.getType().charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    this.nodes.add(Constant.loadInt(0));
                    break;
                }
                case 'F': {
                    this.nodes.add(Constant.loadFloat(0.0f));
                    break;
                }
                case 'D': {
                    this.nodes.add(Constant.loadDouble(0.0));
                    break;
                }
                case 'J': {
                    this.nodes.add(Constant.loadLong(0L));
                    break;
                }
                default: {
                    Preconditions.checkArgument((boolean)false, (String)"Unknown type '%s'", (Object)variable.getType());
                    break;
                }
            }
        } else {
            this.nodes.add(Constant.loadNull());
        }
        this.nodes.add(VariableInstruction.storeVariable(variable));
        return this;
    }

    public BytecodeBlock getVariable(Variable variable) {
        this.nodes.add(VariableInstruction.loadVariable(variable));
        return this;
    }

    public BytecodeBlock putVariable(Variable variable) {
        this.nodes.add(VariableInstruction.storeVariable(variable));
        return this;
    }

    public BytecodeBlock putVariable(Variable variable, Class<?> type) {
        this.nodes.add(Constant.loadClass(type));
        this.putVariable(variable);
        return this;
    }

    public BytecodeBlock putVariable(Variable variable, ParameterizedType type) {
        this.nodes.add(Constant.loadClass(type));
        this.putVariable(variable);
        return this;
    }

    public BytecodeBlock putVariable(Variable variable, String value) {
        this.nodes.add(Constant.loadString(value));
        this.putVariable(variable);
        return this;
    }

    public BytecodeBlock putVariable(Variable variable, Number value) {
        this.nodes.add(Constant.loadNumber(value));
        this.putVariable(variable);
        return this;
    }

    public BytecodeBlock putVariable(Variable variable, int value) {
        this.nodes.add(Constant.loadInt(value));
        this.putVariable(variable);
        return this;
    }

    public BytecodeBlock putVariable(Variable variable, boolean value) {
        this.nodes.add(Constant.loadBoolean(value));
        this.putVariable(variable);
        return this;
    }

    public BytecodeBlock incrementVariable(Variable variable, byte increment) {
        String type = variable.getType().getClassName();
        Preconditions.checkArgument((boolean)ImmutableList.of((Object)"byte", (Object)"short", (Object)"int").contains((Object)type), (String)"variable must be an byte, short or int, but is %s", (Object)type);
        this.nodes.add(VariableInstruction.incrementVariable(variable, increment));
        return this;
    }

    public BytecodeBlock getObjectArrayElement() {
        this.nodes.add(OpCode.AALOAD);
        return this;
    }

    public BytecodeBlock putObjectArrayElement() {
        this.nodes.add(OpCode.AASTORE);
        return this;
    }

    public BytecodeBlock getIntArrayElement() {
        this.nodes.add(OpCode.IALOAD);
        return this;
    }

    public BytecodeBlock putIntArrayElement() {
        this.nodes.add(OpCode.IASTORE);
        return this;
    }

    public BytecodeBlock visitLineNumber(int currentLineNumber) {
        Preconditions.checkArgument((currentLineNumber >= 0 ? 1 : 0) != 0, (Object)"currentLineNumber must be positive");
        if (this.currentLineNumber != currentLineNumber) {
            this.nodes.add(new LineNumberNode(currentLineNumber));
            this.currentLineNumber = currentLineNumber;
        }
        return this;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        for (BytecodeNode node : this.nodes) {
            node.accept(visitor, generationContext);
        }
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitBlock(parent, this);
    }
}

