/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QuantifiedComparisonExpression
extends Expression {
    private final ComparisonExpression.Operator operator;
    private final Quantifier quantifier;
    private final Expression value;
    private final Expression subquery;

    public QuantifiedComparisonExpression(ComparisonExpression.Operator operator, Quantifier quantifier, Expression value, Expression subquery) {
        this(Optional.empty(), operator, quantifier, value, subquery);
    }

    public QuantifiedComparisonExpression(NodeLocation location, ComparisonExpression.Operator operator, Quantifier quantifier, Expression value, Expression subquery) {
        this(Optional.of(location), operator, quantifier, value, subquery);
    }

    private QuantifiedComparisonExpression(Optional<NodeLocation> location, ComparisonExpression.Operator operator, Quantifier quantifier, Expression value, Expression subquery) {
        super(location);
        this.operator = Objects.requireNonNull(operator, "comparisonType is null");
        this.quantifier = Objects.requireNonNull(quantifier, "quantifier is null");
        this.value = Objects.requireNonNull(value, "value is null");
        this.subquery = Objects.requireNonNull(subquery, "subquery is null");
    }

    public ComparisonExpression.Operator getOperator() {
        return this.operator;
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getSubquery() {
        return this.subquery;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuantifiedComparisonExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.value, (Object)this.subquery);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuantifiedComparisonExpression that = (QuantifiedComparisonExpression)o;
        return this.operator == that.operator && this.quantifier == that.quantifier && Objects.equals(this.value, that.value) && Objects.equals(this.subquery, that.subquery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.quantifier, this.value, this.subquery});
    }

    public static enum Quantifier {
        ALL,
        ANY,
        SOME;

    }
}

