/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.CharMatcher;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class CharLiteral
extends Literal {
    private final String value;
    private final Slice slice;

    public CharLiteral(String value) {
        this(Optional.empty(), value);
    }

    public CharLiteral(NodeLocation location, String value) {
        this(Optional.of(location), value);
    }

    public CharLiteral(Optional<NodeLocation> location, String value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        this.value = value;
        this.slice = Slices.utf8Slice((String)CharMatcher.is((char)' ').trimTrailingFrom((CharSequence)value));
    }

    public String getValue() {
        return this.value;
    }

    public Slice getSlice() {
        return this.slice;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCharLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharLiteral that = (CharLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }
}

