/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.airlift.log.Logger;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.sql.presto.PulsarConnector;
import org.apache.pulsar.sql.presto.PulsarConnectorModule;
import org.apache.pulsar.sql.presto.PulsarHandleResolver;

public class PulsarConnectorFactory
implements ConnectorFactory {
    private static final Logger log = Logger.get(PulsarConnectorFactory.class);

    public String getName() {
        return "pulsar";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new PulsarHandleResolver();
    }

    public Connector create(String connectorId, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "requiredConfig is null");
        if (log.isDebugEnabled()) {
            log.debug("Creating Pulsar connector with configs: %s", new Object[]{config});
        }
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new PulsarConnectorModule(connectorId, context.getTypeManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            PulsarConnector connector = (PulsarConnector)injector.getInstance(PulsarConnector.class);
            connector.initConnectorCache();
            return connector;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

