/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import io.netty.buffer.ByteBuf;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class FloatSchema
extends AbstractSchema<Float> {
    private static final FloatSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static FloatSchema of() {
        return INSTANCE;
    }

    public void validate(byte[] message) {
        if (message.length != 4) {
            throw new SchemaSerializationException("Size of data received by FloatSchema is not 4");
        }
    }

    @Override
    public void validate(ByteBuf message) {
        if (message.readableBytes() != 4) {
            throw new SchemaSerializationException("Size of data received by FloatSchema is not 4");
        }
    }

    public byte[] encode(Float message) {
        if (null == message) {
            return null;
        }
        long bits = Float.floatToRawIntBits(message.floatValue());
        return new byte[]{(byte)(bits >>> 24), (byte)(bits >>> 16), (byte)(bits >>> 8), (byte)bits};
    }

    public Float decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        int value = 0;
        for (byte b : bytes) {
            value <<= 8;
            value |= b & 0xFF;
        }
        return Float.valueOf(Float.intBitsToFloat(value));
    }

    @Override
    public Float decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        this.validate(byteBuf);
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value <<= 8;
            value |= byteBuf.getByte(i) & 0xFF;
        }
        return Float.valueOf(Float.intBitsToFloat(value));
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfoImpl().setName("Float").setType(SchemaType.FLOAT).setSchema(new byte[0]);
        INSTANCE = new FloatSchema();
    }
}

