/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.time.Instant;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class InstantSchema
extends AbstractSchema<Instant> {
    private static final InstantSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static InstantSchema of() {
        return INSTANCE;
    }

    public byte[] encode(Instant message) {
        if (null == message) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putLong(message.getEpochSecond());
        buffer.putInt(message.getNano());
        return buffer.array();
    }

    public Instant decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long epochSecond = buffer.getLong();
        int nanos = buffer.getInt();
        return Instant.ofEpochSecond(epochSecond, nanos);
    }

    @Override
    public Instant decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        long epochSecond = byteBuf.readLong();
        int nanos = byteBuf.readInt();
        return Instant.ofEpochSecond(epochSecond, nanos);
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfoImpl().setName("Instant").setType(SchemaType.INSTANT).setSchema(new byte[0]);
        INSTANCE = new InstantSchema();
    }
}

