/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.impl.EntryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.util.SafeRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpAddEntry
extends org.apache.bookkeeper.util.SafeRunnable
implements AsyncCallback.AddCallback,
AsyncCallback.CloseCallback {
    private static final Logger log = LoggerFactory.getLogger(OpAddEntry.class);
    protected ManagedLedgerImpl ml;
    LedgerHandle ledger;
    private long entryId;
    private int numberOfMessages;
    private static final AtomicReferenceFieldUpdater<OpAddEntry, AsyncCallbacks.AddEntryCallback> callbackUpdater = AtomicReferenceFieldUpdater.newUpdater(OpAddEntry.class, AsyncCallbacks.AddEntryCallback.class, "callback");
    protected volatile AsyncCallbacks.AddEntryCallback callback;
    Object ctx;
    volatile long addOpCount;
    private static final AtomicLongFieldUpdater<OpAddEntry> ADD_OP_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(OpAddEntry.class, "addOpCount");
    private boolean closeWhenDone;
    private long startTime;
    volatile long lastInitTime;
    ByteBuf data;
    private int dataLength;
    private static final AtomicReferenceFieldUpdater<OpAddEntry, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OpAddEntry.class, State.class, "state");
    volatile State state;
    private final Recycler.Handle<OpAddEntry> recyclerHandle;
    private static final Recycler<OpAddEntry> RECYCLER = new Recycler<OpAddEntry>(){

        protected OpAddEntry newObject(Recycler.Handle<OpAddEntry> recyclerHandle) {
            return new OpAddEntry(recyclerHandle);
        }
    };

    public static OpAddEntry create(ManagedLedgerImpl ml, ByteBuf data, AsyncCallbacks.AddEntryCallback callback, Object ctx) {
        OpAddEntry op = OpAddEntry.createOpAddEntry(ml, data, callback, ctx);
        if (log.isDebugEnabled()) {
            log.debug("Created new OpAddEntry {}", (Object)op);
        }
        return op;
    }

    public static OpAddEntry create(ManagedLedgerImpl ml, ByteBuf data, int numberOfMessages, AsyncCallbacks.AddEntryCallback callback, Object ctx) {
        OpAddEntry op = OpAddEntry.createOpAddEntry(ml, data, callback, ctx);
        op.numberOfMessages = numberOfMessages;
        if (log.isDebugEnabled()) {
            log.debug("Created new OpAddEntry {}", (Object)op);
        }
        return op;
    }

    private static OpAddEntry createOpAddEntry(ManagedLedgerImpl ml, ByteBuf data, AsyncCallbacks.AddEntryCallback callback, Object ctx) {
        OpAddEntry op = (OpAddEntry)((Object)RECYCLER.get());
        op.ml = ml;
        op.ledger = null;
        op.data = data.retain();
        op.dataLength = data.readableBytes();
        op.callback = callback;
        op.ctx = ctx;
        op.addOpCount = ManagedLedgerImpl.ADD_OP_COUNT_UPDATER.incrementAndGet(ml);
        op.closeWhenDone = false;
        op.entryId = -1L;
        op.startTime = System.nanoTime();
        op.state = State.OPEN;
        ml.mbean.addAddEntrySample(op.dataLength);
        return op;
    }

    public void setLedger(LedgerHandle ledger) {
        this.ledger = ledger;
    }

    public void setCloseWhenDone(boolean closeWhenDone) {
        this.closeWhenDone = closeWhenDone;
    }

    public void initiate() {
        if (STATE_UPDATER.compareAndSet(this, State.OPEN, State.INITIATED)) {
            ByteBuf duplicateBuffer = this.data.retainedDuplicate();
            this.addOpCount = ManagedLedgerImpl.ADD_OP_COUNT_UPDATER.incrementAndGet(this.ml);
            this.lastInitTime = System.nanoTime();
            this.ledger.asyncAddEntry(duplicateBuffer, (AsyncCallback.AddCallback)this, (Object)this.addOpCount);
        } else {
            log.warn("[{}] initiate with unexpected state {}, expect OPEN state.", (Object)this.ml.getName(), (Object)this.state);
        }
    }

    public void failed(ManagedLedgerException e) {
        AsyncCallbacks.AddEntryCallback cb = callbackUpdater.getAndSet(this, null);
        if (cb != null) {
            ReferenceCountUtil.release((Object)this.data);
            cb.addFailed(e, this.ctx);
            this.ml.mbean.recordAddEntryError();
        }
    }

    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        if (!STATE_UPDATER.compareAndSet(this, State.INITIATED, State.COMPLETED)) {
            log.warn("[{}] The add op is terminal legacy callback for entry {}-{} adding.", new Object[]{this.ml.getName(), lh.getId(), entryId});
            this.recycle();
            return;
        }
        if (this.ledger.getId() != lh.getId()) {
            log.warn("[{}] ledgerId {} doesn't match with acked ledgerId {}", new Object[]{this.ml.getName(), this.ledger.getId(), lh.getId()});
        }
        Preconditions.checkArgument((this.ledger.getId() == lh.getId() ? 1 : 0) != 0, (String)"ledgerId %s doesn't match with acked ledgerId %s", (long)this.ledger.getId(), (long)lh.getId());
        if (!this.checkAndCompleteOp(ctx)) {
            return;
        }
        this.entryId = entryId;
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] write-complete: ledger-id={} entry-id={} size={} rc={}", new Object[]{this, this.ml.getName(), lh.getId(), entryId, this.dataLength, rc});
        }
        if (rc != 0) {
            this.handleAddFailure(lh);
        } else {
            this.ml.getExecutor().executeOrdered((Object)this.ml.getName(), (SafeRunnable)this);
        }
    }

    public void safeRun() {
        OpAddEntry firstInQueue = this.ml.pendingAddEntries.poll();
        Preconditions.checkArgument((this == firstInQueue ? 1 : 0) != 0);
        ManagedLedgerImpl.NUMBER_OF_ENTRIES_UPDATER.incrementAndGet(this.ml);
        ManagedLedgerImpl.TOTAL_SIZE_UPDATER.addAndGet(this.ml, this.dataLength);
        if (this.ml.hasActiveCursors()) {
            EntryImpl entry = EntryImpl.create(this.ledger.getId(), this.entryId, this.data);
            this.ml.entryCache.insert(entry);
            entry.release();
        }
        PositionImpl lastEntry = PositionImpl.get(this.ledger.getId(), this.entryId);
        ManagedLedgerImpl.ENTRIES_ADDED_COUNTER_UPDATER.incrementAndGet(this.ml);
        this.ml.lastConfirmedEntry = lastEntry;
        if (this.closeWhenDone) {
            log.info("[{}] Closing ledger {} for being full", (Object)this.ml.getName(), (Object)this.ledger.getId());
            this.ledger.asyncClose((AsyncCallback.CloseCallback)this, this.ctx);
        } else {
            this.updateLatency();
            AsyncCallbacks.AddEntryCallback cb = callbackUpdater.getAndSet(this, null);
            if (cb != null) {
                cb.addComplete(lastEntry, this.data.asReadOnly(), this.ctx);
                this.ml.notifyCursors();
                this.ml.notifyWaitingEntryCallBacks();
                ReferenceCountUtil.release((Object)this.data);
                this.recycle();
            } else {
                ReferenceCountUtil.release((Object)this.data);
            }
        }
    }

    public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
        Preconditions.checkArgument((this.ledger.getId() == lh.getId() ? 1 : 0) != 0, (String)"ledgerId %s doesn't match with acked ledgerId %s", (long)this.ledger.getId(), (long)lh.getId());
        if (rc == 0) {
            log.debug("Successfully closed ledger {}", (Object)lh.getId());
        } else {
            log.warn("Error when closing ledger {}. Status={}", (Object)lh.getId(), (Object)BKException.getMessage((int)rc));
        }
        this.ml.ledgerClosed(lh);
        this.updateLatency();
        AsyncCallbacks.AddEntryCallback cb = callbackUpdater.getAndSet(this, null);
        if (cb != null) {
            cb.addComplete(PositionImpl.get(lh.getId(), this.entryId), this.data.asReadOnly(), ctx);
            this.ml.notifyCursors();
            this.ml.notifyWaitingEntryCallBacks();
            ReferenceCountUtil.release((Object)this.data);
            this.recycle();
        } else {
            ReferenceCountUtil.release((Object)this.data);
        }
    }

    private void updateLatency() {
        this.ml.mbean.addAddEntryLatencySample(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
        this.ml.mbean.addLedgerAddEntryLatencySample(System.nanoTime() - this.lastInitTime, TimeUnit.NANOSECONDS);
    }

    private boolean checkAndCompleteOp(Object ctx) {
        long addOpCount;
        long l = addOpCount = ctx instanceof Long ? (Long)ctx : -1L;
        if (addOpCount != -1L && ADD_OP_COUNT_UPDATER.compareAndSet(this, addOpCount, -1L)) {
            return true;
        }
        log.info("Add-entry already completed for {}-{}", (Object)(this.ledger != null ? this.ledger.getId() : -1L), (Object)this.entryId);
        return false;
    }

    void handleAddTimeoutFailure(LedgerHandle ledger, Object ctx) {
        if (this.checkAndCompleteOp(ctx)) {
            this.close();
            this.handleAddFailure(ledger);
        }
    }

    void handleAddFailure(LedgerHandle ledger) {
        this.ml.mbean.recordAddEntryError();
        this.ml.getExecutor().executeOrdered((Object)this.ml.getName(), (SafeRunnable)SafeRun.safeRun(() -> this.ml.ledgerClosed(ledger)));
    }

    void close() {
        STATE_UPDATER.set(this, State.CLOSED);
    }

    public State getState() {
        return this.state;
    }

    public ByteBuf getData() {
        return this.data;
    }

    public int getNumberOfMessages() {
        return this.numberOfMessages;
    }

    public void setNumberOfMessages(int numberOfMessages) {
        this.numberOfMessages = numberOfMessages;
    }

    public void setData(ByteBuf data) {
        this.data = data;
    }

    private OpAddEntry(Recycler.Handle<OpAddEntry> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.ml = null;
        this.ledger = null;
        this.data = null;
        this.numberOfMessages = 0;
        this.dataLength = -1;
        this.callback = null;
        this.ctx = null;
        this.addOpCount = -1L;
        this.closeWhenDone = false;
        this.entryId = -1L;
        this.startTime = -1L;
        this.lastInitTime = -1L;
        this.recyclerHandle.recycle((Object)this);
    }

    public String toString() {
        ManagedLedgerImpl ml = this.ml;
        LedgerHandle ledger = this.ledger;
        return "OpAddEntry{mlName=" + ml != null ? ml.getName() : ("null, ledgerId=" + ledger != null ? String.valueOf(ledger.getId()) : "null, entryId=" + this.entryId + ", startTime=" + this.startTime + ", dataLength=" + this.dataLength + '}');
    }

    static enum State {
        OPEN,
        INITIATED,
        COMPLETED,
        CLOSED;

    }
}

