/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarColumnMetadata;

public class PulsarInternalColumn {
    public static final PulsarInternalColumn PARTITION = new PulsarInternalColumn("__partition__", (Type)IntegerType.INTEGER, "The partition number which the message belongs to");
    public static final PulsarInternalColumn EVENT_TIME = new PulsarInternalColumn("__event_time__", (Type)TimestampType.TIMESTAMP, "Application defined timestamp in milliseconds of when the event occurred");
    public static final PulsarInternalColumn PUBLISH_TIME = new PulsarInternalColumn("__publish_time__", (Type)TimestampType.TIMESTAMP, "The timestamp in milliseconds of when event as published");
    public static final PulsarInternalColumn MESSAGE_ID = new PulsarInternalColumn("__message_id__", (Type)VarcharType.VARCHAR, "The message ID of the message used to generate this row");
    public static final PulsarInternalColumn SEQUENCE_ID = new PulsarInternalColumn("__sequence_id__", (Type)BigintType.BIGINT, "The sequence ID of the message used to generate this row");
    public static final PulsarInternalColumn PRODUCER_NAME = new PulsarInternalColumn("__producer_name__", (Type)VarcharType.VARCHAR, "The name of the producer that publish the message used to generate this row");
    public static final PulsarInternalColumn KEY = new PulsarInternalColumn("__key__", (Type)VarcharType.VARCHAR, "The partition key for the topic");
    public static final PulsarInternalColumn PROPERTIES = new PulsarInternalColumn("__properties__", (Type)VarcharType.VARCHAR, "User defined properties");
    private static Set<PulsarInternalColumn> internalFields = ImmutableSet.of((Object)PARTITION, (Object)EVENT_TIME, (Object)PUBLISH_TIME, (Object)MESSAGE_ID, (Object)SEQUENCE_ID, (Object)PRODUCER_NAME, (Object[])new PulsarInternalColumn[]{KEY, PROPERTIES});
    private final String name;
    private final Type type;
    private final String comment;

    PulsarInternalColumn(String name, Type type, String comment) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = name;
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    PulsarColumnHandle getColumnHandle(String connectorId, boolean hidden) {
        return new PulsarColumnHandle(connectorId, this.getName(), this.getType(), hidden, true, this.getName(), null, null, PulsarColumnHandle.HandleKeyValueType.NONE);
    }

    PulsarColumnMetadata getColumnMetadata(boolean hidden) {
        return new PulsarColumnMetadata(this.name, this.type, this.comment, null, hidden, true, PulsarColumnHandle.HandleKeyValueType.NONE, new PulsarColumnMetadata.DecoderExtraInfo());
    }

    public static Set<PulsarInternalColumn> getInternalFields() {
        return internalFields;
    }

    public static Map<String, PulsarInternalColumn> getInternalFieldsMap() {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        PulsarInternalColumn.getInternalFields().forEach(new Consumer<PulsarInternalColumn>(){

            @Override
            public void accept(PulsarInternalColumn pulsarInternalColumn) {
                builder.put((Object)pulsarInternalColumn.getName(), (Object)pulsarInternalColumn);
            }
        });
        return builder.build();
    }
}

