/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.BrokerStats;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.stats.AllocatorStats;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class BrokerStatsImpl
extends BaseResource
implements BrokerStats {
    private final WebTarget adminBrokerStats;
    private final WebTarget adminV2BrokerStats;

    public BrokerStatsImpl(WebTarget target, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminBrokerStats = target.path("/admin/broker-stats");
        this.adminV2BrokerStats = target.path("/admin/v2/broker-stats");
    }

    public String getMetrics() throws PulsarAdminException {
        try {
            return this.getMetricsAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<String> getMetricsAsync() {
        WebTarget path = this.adminV2BrokerStats.path("/metrics");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String s) {
                future.complete(s);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokerStatsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public AllocatorStats getAllocatorStats(String allocatorName) throws PulsarAdminException {
        try {
            return this.getAllocatorStatsAsync(allocatorName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<AllocatorStats> getAllocatorStatsAsync(String allocatorName) {
        WebTarget path = this.adminV2BrokerStats.path("/allocator-stats").path(allocatorName);
        final CompletableFuture<AllocatorStats> future = new CompletableFuture<AllocatorStats>();
        this.asyncGetRequest(path, new InvocationCallback<AllocatorStats>(){

            @Override
            public void completed(AllocatorStats allocatorStats) {
                future.complete(allocatorStats);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokerStatsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public String getMBeans() throws PulsarAdminException {
        try {
            return this.getMBeansAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<String> getMBeansAsync() {
        WebTarget path = this.adminV2BrokerStats.path("/mbeans");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String s) {
                future.complete(s);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokerStatsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public String getTopics() throws PulsarAdminException {
        try {
            return this.getTopicsAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<String> getTopicsAsync() {
        WebTarget path = this.adminV2BrokerStats.path("/topics");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String s) {
                future.complete(s);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokerStatsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public LoadManagerReport getLoadReport() throws PulsarAdminException {
        try {
            return this.getLoadReportAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<LoadManagerReport> getLoadReportAsync() {
        WebTarget path = this.adminV2BrokerStats.path("/load-report");
        final CompletableFuture<LoadManagerReport> future = new CompletableFuture<LoadManagerReport>();
        this.asyncGetRequest(path, new InvocationCallback<LoadManagerReport>(){

            @Override
            public void completed(LoadManagerReport loadManagerReport) {
                future.complete(loadManagerReport);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokerStatsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public String getPendingBookieOpsStats() throws PulsarAdminException {
        try {
            return this.getPendingBookieOpsStatsAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<String> getPendingBookieOpsStatsAsync() {
        WebTarget path = this.adminV2BrokerStats.path("/bookieops");
        final CompletableFuture<String> future = new CompletableFuture<String>();
        this.asyncGetRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String s) {
                future.complete(s);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BrokerStatsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public JsonObject getBrokerResourceAvailability(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get((String)namespace);
            WebTarget admin = ns.isV2() ? this.adminV2BrokerStats : this.adminBrokerStats;
            String json = this.request(admin.path("/broker-resource-availability").path(ns.toString())).get(String.class);
            return (JsonObject)new Gson().fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

