/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.Transactions;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorStatus;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class TransactionsImpl
extends BaseResource
implements Transactions {
    private final WebTarget adminV3Transactions;

    public TransactionsImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminV3Transactions = web.path("/admin/v3/transactions");
    }

    public CompletableFuture<TransactionCoordinatorStatus> getCoordinatorStatusById(int coordinatorId) {
        WebTarget path = this.adminV3Transactions.path("coordinatorStatus");
        path = path.queryParam("coordinatorId", coordinatorId);
        final CompletableFuture<TransactionCoordinatorStatus> future = new CompletableFuture<TransactionCoordinatorStatus>();
        this.asyncGetRequest(path, new InvocationCallback<TransactionCoordinatorStatus>(){

            @Override
            public void completed(TransactionCoordinatorStatus status) {
                future.complete(status);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<Map<Integer, TransactionCoordinatorStatus>> getCoordinatorStatus() {
        WebTarget path = this.adminV3Transactions.path("coordinatorStatus");
        final CompletableFuture<Map<Integer, TransactionCoordinatorStatus>> status = new CompletableFuture<Map<Integer, TransactionCoordinatorStatus>>();
        this.asyncGetRequest(path, new InvocationCallback<Map<Integer, TransactionCoordinatorStatus>>(){

            @Override
            public void completed(Map<Integer, TransactionCoordinatorStatus> topics) {
                status.complete(topics);
            }

            @Override
            public void failed(Throwable throwable) {
                status.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return status;
    }

    public CompletableFuture<TransactionInBufferStats> getTransactionInBufferStats(TxnID txnID, String topic) {
        WebTarget path = this.adminV3Transactions.path("transactionInBufferStats");
        path = path.queryParam("mostSigBits", txnID.getMostSigBits());
        path = path.queryParam("leastSigBits", txnID.getLeastSigBits());
        path = path.queryParam("topic", topic);
        final CompletableFuture<TransactionInBufferStats> future = new CompletableFuture<TransactionInBufferStats>();
        this.asyncGetRequest(path, new InvocationCallback<TransactionInBufferStats>(){

            @Override
            public void completed(TransactionInBufferStats stats) {
                future.complete(stats);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public CompletableFuture<TransactionInPendingAckStats> getTransactionInPendingAckStats(TxnID txnID, String topic, String subName) {
        WebTarget path = this.adminV3Transactions.path("transactionInPendingAckStats");
        path = path.queryParam("mostSigBits", txnID.getMostSigBits());
        path = path.queryParam("leastSigBits", txnID.getLeastSigBits());
        path = path.queryParam("topic", topic);
        path = path.queryParam("subName", subName);
        final CompletableFuture<TransactionInPendingAckStats> future = new CompletableFuture<TransactionInPendingAckStats>();
        this.asyncGetRequest(path, new InvocationCallback<TransactionInPendingAckStats>(){

            @Override
            public void completed(TransactionInPendingAckStats stats) {
                future.complete(stats);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(TransactionsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }
}

