/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.net.ConnectException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.shade.javax.ws.rs.ClientErrorException;
import org.apache.pulsar.shade.javax.ws.rs.ServerErrorException;
import org.apache.pulsar.shade.javax.ws.rs.ServiceUnavailableException;
import org.apache.pulsar.shade.javax.ws.rs.WebApplicationException;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.Invocation;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResource {
    private static final Logger log = LoggerFactory.getLogger(BaseResource.class);
    protected final Authentication auth;
    protected final long readTimeoutMs;

    protected BaseResource(Authentication auth, long readTimeoutMs) {
        this.auth = auth;
        this.readTimeoutMs = readTimeoutMs;
    }

    public Invocation.Builder request(WebTarget target) throws PulsarAdminException {
        try {
            return this.requestAsync(target).get();
        }
        catch (Exception e) {
            throw new PulsarAdminException.GettingAuthenticationDataException((Throwable)e);
        }
    }

    public CompletableFuture<Invocation.Builder> requestAsync(WebTarget target) {
        CompletableFuture<Invocation.Builder> builderFuture = new CompletableFuture<Invocation.Builder>();
        CompletableFuture authFuture = new CompletableFuture();
        try {
            AuthenticationDataProvider authData = this.auth.getAuthData(target.getUri().getHost());
            if (authData.hasDataForHttp()) {
                this.auth.authenticationStage(target.getUri().toString(), authData, null, authFuture);
            } else {
                authFuture.complete(null);
            }
            authFuture.whenComplete((respHeaders, ex) -> {
                if (ex != null) {
                    log.warn("[{}] Failed to perform http request at auth stage: {}", (Object)target.getUri(), (Object)ex.getMessage());
                    builderFuture.completeExceptionally(new PulsarClientException(ex));
                    return;
                }
                try {
                    Set headers;
                    Invocation.Builder builder = target.request("application/json");
                    if (authData.hasDataForHttp() && (headers = this.auth.newRequestHeader(target.getUri().toString(), authData, respHeaders)) != null) {
                        headers.forEach(entry -> builder.header((String)entry.getKey(), entry.getValue()));
                    }
                    builderFuture.complete(builder);
                }
                catch (Throwable t) {
                    builderFuture.completeExceptionally((Throwable)new PulsarAdminException.GettingAuthenticationDataException(t));
                }
            });
        }
        catch (Throwable t) {
            builderFuture.completeExceptionally((Throwable)new PulsarAdminException.GettingAuthenticationDataException(t));
        }
        return builderFuture;
    }

    public <T> CompletableFuture<Void> asyncPutRequest(final WebTarget target, Entity<T> entity) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(target).async().put(entity, new InvocationCallback<ErrorData>(){

                @Override
                public void completed(ErrorData response) {
                    future.complete(null);
                }

                @Override
                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http put request: {}", (Object)target.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public <T> CompletableFuture<Void> asyncPostRequest(final WebTarget target, Entity<T> entity) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(target).async().post(entity, new InvocationCallback<ErrorData>(){

                @Override
                public void completed(ErrorData response) {
                    future.complete(null);
                }

                @Override
                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http post request: {}", (Object)target.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public <T> void asyncGetRequest(WebTarget target, InvocationCallback<T> callback) {
        try {
            this.request(target).async().get(callback);
        }
        catch (PulsarAdminException cae) {
            callback.failed(cae);
        }
    }

    public CompletableFuture<Void> asyncDeleteRequest(final WebTarget target) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(target).async().delete(new InvocationCallback<ErrorData>(){

                @Override
                public void completed(ErrorData response) {
                    future.complete(null);
                }

                @Override
                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http delete request: {}", (Object)target.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public <T> void asyncDeleteRequest(WebTarget target, InvocationCallback<T> callback) {
        try {
            this.request(target).async().delete(callback);
        }
        catch (PulsarAdminException cae) {
            callback.failed(cae);
        }
    }

    public PulsarAdminException getApiException(Throwable e) {
        if (e instanceof PulsarAdminException) {
            return (PulsarAdminException)e;
        }
        if (e instanceof ServiceUnavailableException) {
            if (e.getCause() instanceof ConnectException) {
                return new PulsarAdminException.ConnectException(e.getCause());
            }
            return new PulsarAdminException((ServerErrorException)e);
        }
        if (e instanceof WebApplicationException) {
            if (e instanceof ServerErrorException) {
                ServerErrorException see = (ServerErrorException)e;
                return new PulsarAdminException.ServerSideErrorException(see, e.getMessage());
            }
            if (e instanceof ClientErrorException) {
                ClientErrorException cee = (ClientErrorException)e;
                int statusCode = cee.getResponse().getStatus();
                switch (statusCode) {
                    case 401: 
                    case 403: {
                        return new PulsarAdminException.NotAuthorizedException(cee);
                    }
                    case 404: {
                        return new PulsarAdminException.NotFoundException(cee);
                    }
                    case 405: {
                        return new PulsarAdminException.NotAllowedException(cee);
                    }
                    case 409: {
                        return new PulsarAdminException.ConflictException(cee);
                    }
                    case 412: {
                        return new PulsarAdminException.PreconditionFailedException(cee);
                    }
                }
                return new PulsarAdminException(cee);
            }
            return new PulsarAdminException((WebApplicationException)e);
        }
        return new PulsarAdminException(e);
    }

    public PulsarAdminException getApiException(Response response) {
        if (response.getStatusInfo().equals(Response.Status.OK)) {
            return null;
        }
        try {
            if (response.getStatus() >= 500) {
                throw new ServerErrorException(response);
            }
            if (response.getStatus() >= 400) {
                throw new ClientErrorException(response);
            }
            throw new WebApplicationException(response);
        }
        catch (Exception e) {
            return this.getApiException(e);
        }
    }
}

