/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSqlSchemaInfoProvider
implements SchemaInfoProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarSqlSchemaInfoProvider.class);
    private final TopicName topicName;
    private final PulsarAdmin pulsarAdmin;
    private final Type type;
    private final LoadingCache<BytesSchemaVersion, SchemaInfo> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BytesSchemaVersion, SchemaInfo>(){

        public SchemaInfo load(BytesSchemaVersion schemaVersion) throws Exception {
            return PulsarSqlSchemaInfoProvider.this.loadSchema(schemaVersion);
        }
    });

    PulsarSqlSchemaInfoProvider(TopicName topicName, PulsarAdmin pulsarAdmin, Type type) {
        this.topicName = topicName;
        this.pulsarAdmin = pulsarAdmin;
        this.type = type;
    }

    public CompletableFuture<SchemaInfo> getSchemaByVersion(byte[] schemaVersion) {
        try {
            if (null == schemaVersion) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.completedFuture(this.cache.get((Object)BytesSchemaVersion.of((byte[])schemaVersion)));
        }
        catch (ExecutionException e) {
            LOG.error("Can't get generic schema for topic {} schema version {}", new Object[]{this.topicName.toString(), new String(schemaVersion, StandardCharsets.UTF_8), e});
            return FutureUtil.failedFuture((Throwable)e.getCause());
        }
    }

    public CompletableFuture<SchemaInfo> getLatestSchema() {
        try {
            return CompletableFuture.completedFuture(this.pulsarAdmin.schemas().getSchemaInfo(this.topicName.toString()));
        }
        catch (PulsarAdminException e) {
            LOG.error("Can't get current schema for topic {}", (Object)this.topicName.toString(), (Object)e);
            return FutureUtil.failedFuture((Throwable)e.getCause());
        }
    }

    public String getTopicName() {
        return this.topicName.getLocalName();
    }

    private SchemaInfo loadSchema(BytesSchemaVersion bytesSchemaVersion) throws PulsarAdminException {
        SchemaInfo schemaInfo = this.pulsarAdmin.schemas().getSchemaInfo(this.topicName.toString(), ByteBuffer.wrap(bytesSchemaVersion.get()).getLong());
        switch (this.type) {
            case NONE: {
                return schemaInfo;
            }
            case Key: {
                return (SchemaInfo)KeyValueSchemaInfo.decodeKeyValueSchemaInfo(schemaInfo).getKey();
            }
            case Value: {
                return (SchemaInfo)KeyValueSchemaInfo.decodeKeyValueSchemaInfo(schemaInfo).getValue();
            }
        }
        throw new PulsarAdminException((Throwable)new PulsarClientException.NotSupportedException("PulsarSqlSchemaInfoProvider don't support this Type : " + (Object)((Object)this.type)));
    }

    public static enum Type {
        NONE,
        Key,
        Value;

    }
}

