/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.util.List;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.sql.presto.AvroSchemaHandler;
import org.apache.pulsar.sql.presto.JSONSchemaHandler;
import org.apache.pulsar.sql.presto.KeyValueSchemaHandler;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarPrimitiveSchemaHandler;
import org.apache.pulsar.sql.presto.PulsarSqlSchemaInfoProvider;
import org.apache.pulsar.sql.presto.SchemaHandler;

class PulsarSchemaHandlers {
    PulsarSchemaHandlers() {
    }

    static SchemaHandler newPulsarSchemaHandler(TopicName topicName, PulsarConnectorConfig pulsarConnectorConfig, SchemaInfo schemaInfo, List<PulsarColumnHandle> columnHandles, PulsarSqlSchemaInfoProvider.Type type) throws RuntimeException {
        if (schemaInfo.getType().isPrimitive()) {
            return new PulsarPrimitiveSchemaHandler(schemaInfo);
        }
        if (schemaInfo.getType().isStruct()) {
            try {
                switch (schemaInfo.getType()) {
                    case JSON: {
                        return new JSONSchemaHandler(columnHandles);
                    }
                    case AVRO: {
                        return new AvroSchemaHandler(topicName, pulsarConnectorConfig, schemaInfo, columnHandles, type);
                    }
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Not supported schema type: " + schemaInfo.getType());
            }
            catch (PulsarClientException e) {
                throw new RuntimeException(new Throwable("PulsarAdmin gets version schema fail, topicName : " + topicName.toString(), e));
            }
        }
        if (schemaInfo.getType().equals((Object)SchemaType.KEY_VALUE)) {
            return new KeyValueSchemaHandler(topicName, pulsarConnectorConfig, schemaInfo, columnHandles);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Schema `" + schemaInfo.getType() + "` is not supported by presto yet : " + schemaInfo);
    }

    static SchemaInfo defaultSchema() {
        return Schema.BYTES.getSchemaInfo();
    }
}

