/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarRecordSet;
import org.apache.pulsar.sql.presto.PulsarSplit;

public class PulsarRecordSetProvider
implements ConnectorRecordSetProvider {
    private final PulsarConnectorConfig pulsarConnectorConfig;

    @Inject
    public PulsarRecordSetProvider(PulsarConnectorConfig pulsarConnectorConfig) {
        this.pulsarConnectorConfig = Objects.requireNonNull(pulsarConnectorConfig, "pulsarConnectorConfig is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        Objects.requireNonNull(split, "Connector split is null");
        PulsarSplit pulsarSplit = (PulsarSplit)split;
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)((PulsarColumnHandle)columnHandle));
        }
        return new PulsarRecordSet(pulsarSplit, (List<PulsarColumnHandle>)handles.build(), this.pulsarConnectorConfig);
    }
}

