/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.log.Logger;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroSchema;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.sql.presto.PulsarColumnHandle;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarSqlSchemaInfoProvider;
import org.apache.pulsar.sql.presto.SchemaHandler;

public class AvroSchemaHandler
implements SchemaHandler {
    private final List<PulsarColumnHandle> columnHandles;
    private final GenericAvroSchema genericAvroSchema;
    private final SchemaInfo schemaInfo;
    private static final Logger log = Logger.get(AvroSchemaHandler.class);

    AvroSchemaHandler(TopicName topicName, PulsarConnectorConfig pulsarConnectorConfig, SchemaInfo schemaInfo, List<PulsarColumnHandle> columnHandles, PulsarSqlSchemaInfoProvider.Type type) throws PulsarClientException {
        this(new PulsarSqlSchemaInfoProvider(topicName, pulsarConnectorConfig.getPulsarAdmin(), type), schemaInfo, columnHandles);
    }

    AvroSchemaHandler(PulsarSqlSchemaInfoProvider pulsarSqlSchemaInfoProvider, SchemaInfo schemaInfo, List<PulsarColumnHandle> columnHandles) {
        this.schemaInfo = schemaInfo;
        this.genericAvroSchema = new GenericAvroSchema(schemaInfo);
        this.genericAvroSchema.setSchemaInfoProvider(pulsarSqlSchemaInfoProvider);
        this.columnHandles = columnHandles;
    }

    @Override
    public Object deserialize(ByteBuf payload) {
        return this.genericAvroSchema.decode(payload);
    }

    @Override
    public Object deserialize(ByteBuf payload, byte[] schemaVersion) {
        return this.genericAvroSchema.decode(payload, schemaVersion);
    }

    @Override
    public Object extractField(int index, Object currentRecord) {
        try {
            GenericAvroRecord record = (GenericAvroRecord)currentRecord;
            PulsarColumnHandle pulsarColumnHandle = this.columnHandles.get(index);
            String[] names = pulsarColumnHandle.getFieldNames();
            if (names.length == 1) {
                return record.getField(pulsarColumnHandle.getFieldNames()[0]);
            }
            for (int i = 0; i < names.length - 1; ++i) {
                record = (GenericAvroRecord)record.getField(names[i]);
            }
            return record.getField(names[names.length - 1]);
        }
        catch (Exception ex) {
            log.debug((Throwable)ex, "%s", new Object[]{ex});
            return null;
        }
    }

    @VisibleForTesting
    GenericAvroSchema getSchema() {
        return this.genericAvroSchema;
    }

    @VisibleForTesting
    SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }
}

