/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.Type;
import java.util.Arrays;
import java.util.Objects;

public class PulsarColumnHandle
implements ColumnHandle {
    private final String connectorId;
    private final String name;
    private final Type type;
    private final boolean hidden;
    private final boolean internal;
    private final String[] fieldNames;
    private final Integer[] positionIndices;
    private HandleKeyValueType handleKeyValueType;

    @JsonCreator
    public PulsarColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="hidden") boolean hidden, @JsonProperty(value="internal") boolean internal, @JsonProperty(value="fieldNames") String[] fieldNames, @JsonProperty(value="positionIndices") Integer[] positionIndices, @JsonProperty(value="handleKeyValueType") HandleKeyValueType handleKeyValueType) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.hidden = hidden;
        this.internal = internal;
        this.fieldNames = fieldNames;
        this.positionIndices = positionIndices;
        this.handleKeyValueType = handleKeyValueType == null ? HandleKeyValueType.NONE : handleKeyValueType;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @JsonProperty
    public boolean isInternal() {
        return this.internal;
    }

    @JsonProperty
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public Integer[] getPositionIndices() {
        return this.positionIndices;
    }

    @JsonProperty
    public HandleKeyValueType getHandleKeyValueType() {
        return this.handleKeyValueType;
    }

    @JsonIgnore
    public boolean isKey() {
        return Objects.equals((Object)this.handleKeyValueType, (Object)HandleKeyValueType.KEY);
    }

    @JsonIgnore
    public boolean isValue() {
        return Objects.equals((Object)this.handleKeyValueType, (Object)HandleKeyValueType.VALUE);
    }

    ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.name, this.type, null, this.hidden);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PulsarColumnHandle that = (PulsarColumnHandle)o;
        if (this.hidden != that.hidden) {
            return false;
        }
        if (this.internal != that.internal) {
            return false;
        }
        if (this.connectorId != null ? !this.connectorId.equals(that.connectorId) : that.connectorId != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (!Arrays.deepEquals(this.fieldNames, that.fieldNames)) {
            return false;
        }
        if (!Arrays.deepEquals(this.positionIndices, that.positionIndices)) {
            return false;
        }
        return Objects.equals((Object)this.handleKeyValueType, (Object)that.handleKeyValueType);
    }

    public int hashCode() {
        int result = this.connectorId != null ? this.connectorId.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.hidden ? 1 : 0);
        result = 31 * result + (this.internal ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.fieldNames);
        result = 31 * result + Arrays.hashCode((Object[])this.positionIndices);
        result = 31 * result + (this.handleKeyValueType != null ? this.handleKeyValueType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PulsarColumnHandle{connectorId='" + this.connectorId + '\'' + ", name='" + this.name + '\'' + ", type=" + this.type + ", hidden=" + this.hidden + ", internal=" + this.internal + ", fieldNames=" + Arrays.toString(this.fieldNames) + ", positionIndices=" + Arrays.toString((Object[])this.positionIndices) + ", handleKeyValueType=" + (Object)((Object)this.handleKeyValueType) + '}';
    }

    public static enum HandleKeyValueType {
        NONE,
        KEY,
        VALUE;

    }
}

